/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.util.Policy;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.ClassRule;
import org.junit.Test;

public class CollatorPerformanceTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private static final int ARRAYSIZE = 100000;
    private static String[] fArray;

    public CollatorPerformanceTest() {
        this.generateArray();
    }

    @Test
    public void testCollator() {
        Comparator comparator = Policy.getComparator();
        int i = 0;
        while (i < 15) {
            String[] array = (String[])fArray.clone();
            this.startMeasuring();
            Arrays.sort(array, comparator);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void generateArray() {
        if (fArray == null) {
            fArray = new String[100000];
            int count = 99999;
            while (count >= 0) {
                int i = 0;
                while (i < 26) {
                    int j = 0;
                    while (j < 26) {
                        int k = 0;
                        while (k < 26) {
                            if (count < 0) {
                                return;
                            }
                            CollatorPerformanceTest.fArray[count] = k % 2 == 0 ? new String(new char[]{(char)(i + 97), (char)(j + 65), (char)(k + 97)}) : (k % 3 == 0 ? new String(new char[]{(char)(i + 97), (char)(j + 97), (char)(k + 65)}) : new String(new char[]{(char)(i + 65), (char)(j + 97), (char)(k + 97)}));
                            --count;
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }
}

