/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.RefreshTestContentProvider;
import org.eclipse.jface.tests.performance.ViewerTest;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Test;

public class ComboViewerRefreshTest
extends ViewerTest {
    ComboViewer viewer;
    private RefreshTestContentProvider contentProvider;
    private static int ELEMENT_COUNT;

    @Override
    protected StructuredViewer createViewer(Shell shell) {
        this.viewer = new ComboViewer((Composite)shell);
        this.contentProvider = new RefreshTestContentProvider(ELEMENT_COUNT);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        return this.viewer;
    }

    @Test
    public void testRefresh() throws Throwable {
        ELEMENT_COUNT = 1000;
        this.openBrowser();
        ComboViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            this.viewer.refresh();
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testRefreshSmall() throws Throwable {
        ELEMENT_COUNT = 50;
        this.openBrowser();
        ComboViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            int i = 0;
            while (i < 1000) {
                this.viewer.refresh();
                ++i;
            }
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

