/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.RefreshTestContentProvider;
import org.eclipse.jface.tests.performance.TableViewerRefreshTest;
import org.eclipse.jface.tests.performance.TestElement;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Test;

public class FastTableViewerRefreshTest
extends TableViewerRefreshTest {
    @Test
    public void testRefreshMultiple() throws Throwable {
        this.openBrowser();
        FastTableViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            int i = 0;
            while (i < 10) {
                this.viewer.refresh();
                UITestUtil.processEvents();
                ++i;
            }
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testUpdateMultiple() throws Throwable {
        this.openBrowser();
        FastTableViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            int i = 0;
            while (i < 10) {
                TableItem[] items = this.viewer.getTable().getItems();
                int j = 0;
                while (j < items.length) {
                    TableItem item = items[j];
                    TestElement element = RefreshTestContentProvider.allElements[j];
                    this.viewer.testUpdateItem((Widget)item, element);
                    ++j;
                }
                UITestUtil.processEvents();
                ++i;
            }
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

