/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.TreeAddTest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Test;

public class FastTreeTest
extends TreeAddTest {
    @Test
    public void testAddTenTenTimes() throws CoreException {
        this.doTestAdd(10, TEST_COUNT, false);
    }

    @Test
    public void testAddFiftyTenTimes() throws CoreException {
        this.doTestAdd(50, TEST_COUNT, false);
    }

    @Test
    public void testAddHundredTenTimes() throws CoreException {
        this.tagAsSummary("JFace - Add 10000 items 100 at a time TreeViewer 10 times", Dimension.ELAPSED_PROCESS);
        this.doTestAdd(100, TEST_COUNT, false);
    }

    @Override
    protected void doTestAdd(int increment, int total, boolean preSort) throws CoreException {
        this.openBrowser();
        FastTreeTest.exercise(() -> {
            TestTreeElement input = new TestTreeElement(0, null);
            this.viewer.setInput((Object)input);
            input.createChildren(total);
            if (preSort) {
                this.viewer.getComparator().sort((Viewer)this.viewer, (Object[])input.children);
            }
            ArrayList<Object[]> batches = new ArrayList<Object[]>();
            int blocks = input.children.length / increment;
            int j = 0;
            while (j < blocks) {
                Object[] batch1 = new Object[increment];
                System.arraycopy(input.children, j * increment, batch1, 0, increment);
                batches.add(batch1);
                j += increment;
            }
            UITestUtil.processEvents();
            Object[] batchArray = batches.toArray();
            this.startMeasuring();
            int i = 0;
            while (i < 10) {
                this.viewer.remove((Object[])input.children);
                Object[] objectArray = batchArray;
                int n3 = batchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object batch2 = objectArray[n4];
                    this.viewer.add((Object)input, (Object[])batch2);
                    UITestUtil.processEvents();
                    ++n4;
                }
                ++i;
            }
            this.stopMeasuring();
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

