/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FileImageDescriptorTest
extends BasicPerformanceTest {
    protected static final String IMAGES_DIRECTORY = "/icons/imagetests";

    @Test
    public void testRefresh() throws Throwable {
        FileImageDescriptorTest.exercise(() -> {
            Class missing = null;
            ArrayList<Image> images = new ArrayList<Image>();
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            Enumeration bundleEntries = bundle.getEntryPaths(IMAGES_DIRECTORY);
            while (bundleEntries.hasMoreElements()) {
                URL[] files;
                String localImagePath = (String)bundleEntries.nextElement();
                if (localImagePath.indexOf(46) < 0) continue;
                URL[] uRLArray = files = FileLocator.findEntries((Bundle)bundle, (IPath)IPath.fromOSString((String)localImagePath));
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    URL file = uRLArray[n2];
                    this.startMeasuring();
                    ImageDescriptor descriptor = ImageDescriptor.createFromFile(missing, (String)FileLocator.toFileURL((URL)file).getFile());
                    int j = 0;
                    while (j < 10) {
                        Image image = descriptor.createImage();
                        images.add(image);
                        ++j;
                    }
                    UITestUtil.processEvents();
                    this.stopMeasuring();
                    ++n2;
                }
            }
            Iterator imageIterator = images.iterator();
            while (imageIterator.hasNext()) {
                ((Image)imageIterator.next()).dispose();
            }
        }, 20, 100, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

