/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.junit.Test;

public class ListPopulationTest
extends BasicPerformanceTest {
    List list;

    protected void openBrowser() {
        Display fDisplay = Display.getCurrent();
        if (fDisplay == null) {
            fDisplay = new Display();
        }
        Shell shell = new Shell(fDisplay);
        shell.setSize(500, 500);
        shell.setLayout((Layout)new FillLayout());
        this.list = new List((Composite)shell, 0);
        shell.open();
    }

    @Test
    public void testSmallAdd() throws Throwable {
        this.addBench(100);
    }

    @Test
    public void testSmallSetItems() throws Throwable {
        this.setItemsBench(100);
    }

    @Test
    public void testMediumAdd() throws Throwable {
        this.addBench(5000);
    }

    @Test
    public void testMediumSetItems() throws Throwable {
        this.setItemsBench(5000);
    }

    @Test
    public void testLargeAdd() throws Throwable {
        this.addBench(50000);
    }

    @Test
    public void testLargeSetItems() throws Throwable {
        this.setItemsBench(50000);
    }

    public void addBench(int count) throws Throwable {
        this.openBrowser();
        String[] items = this.getItems(count);
        ListPopulationTest.exercise(() -> {
            this.list.removeAll();
            this.startMeasuring();
            String[] stringArray2 = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray2[n2];
                this.list.add(item);
                ++n2;
            }
            UITestUtil.processEvents();
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void setItemsBench(int count) throws Throwable {
        this.openBrowser();
        String[] items = this.getItems(count);
        ListPopulationTest.exercise(() -> {
            this.list.removeAll();
            this.startMeasuring();
            this.list.setItems(items);
            UITestUtil.processEvents();
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    private String[] getItems(int count) {
        String[] items = new String[count];
        int j = 0;
        while (j < items.length) {
            items[j] = "Element " + j;
            ++j;
        }
        return items;
    }
}

