/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.ClassRule;
import org.junit.Test;

public class ProgressMonitorDialogPerformanceTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();

    @Test
    public void testLongNames() throws Throwable {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        Shell shell = new Shell(display);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = monitor -> {
            char[] chars = new char[10000];
            int i = 0;
            while (i < chars.length) {
                chars[i] = 65;
                ++i;
            }
            String taskName = new String(chars);
            monitor.setTaskName(taskName);
            UITestUtil.processEvents();
            int testCounter = 0;
            while (testCounter < 20) {
                this.startMeasuring();
                int counter = 0;
                while (counter < 30) {
                    monitor.setTaskName(taskName);
                    UITestUtil.processEvents();
                    ++counter;
                }
                UITestUtil.processEvents();
                this.stopMeasuring();
                ++testCounter;
            }
        };
        dialog.run(false, true, runnable);
        this.commitMeasurements();
        this.assertPerformance();
        shell.dispose();
    }
}

