/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.TreeAddTest;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.junit.Test;

public class SWTTreeTest
extends BasicPerformanceTest {
    Shell browserShell;
    Tree tree;

    protected void openBrowser() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        this.browserShell = new Shell(display);
        this.browserShell.setSize(500, 500);
        this.browserShell.setLayout((Layout)new FillLayout());
        this.tree = new Tree((Composite)this.browserShell, 0);
        this.createChildren();
        this.browserShell.open();
    }

    private void createChildren() {
        int i = 0;
        while (i < TreeAddTest.TEST_COUNT) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText("Element " + i);
            ++i;
        }
    }

    @Test
    public void testGetItems() throws CoreException {
        this.openBrowser();
        SWTTreeTest.exercise(() -> {
            UITestUtil.processEvents();
            this.startMeasuring();
            int j = 0;
            while (j < TreeAddTest.TEST_COUNT) {
                this.tree.getItems();
                UITestUtil.processEvents();
                ++j;
            }
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
        this.browserShell.close();
    }

    @Test
    public void testGetItemAt() throws CoreException {
        this.openBrowser();
        SWTTreeTest.exercise(() -> {
            UITestUtil.processEvents();
            this.startMeasuring();
            int j = 0;
            while (j < TreeAddTest.TEST_COUNT) {
                this.tree.getItem(j);
                UITestUtil.processEvents();
                ++j;
            }
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
        this.browserShell.close();
    }
}

