/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.RefreshTestContentProvider;
import org.eclipse.jface.tests.performance.TestElement;
import org.eclipse.jface.tests.performance.ViewerTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Test;

public class TableViewerRefreshTest
extends ViewerTest {
    TestTableViewer viewer;
    private RefreshTestContentProvider contentProvider;

    @Override
    protected StructuredViewer createViewer(Shell shell) {
        this.viewer = new TestTableViewer((Composite)shell);
        this.contentProvider = new RefreshTestContentProvider(RefreshTestContentProvider.ELEMENT_COUNT);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        return this.viewer;
    }

    @Test
    public void testRefresh() throws Throwable {
        this.openBrowser();
        TableViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            this.viewer.refresh();
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testRefreshSorted() throws Throwable {
        this.openBrowser();
        this.viewer.setComparator(new ViewerComparator());
        TableViewerRefreshTest.exercise(() -> {
            this.startMeasuring();
            this.viewer.refresh();
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testRefreshPreSorted() throws Throwable {
        this.openBrowser();
        ViewerComparator sorter = new ViewerComparator();
        this.viewer.setComparator(sorter);
        TableViewerRefreshTest.exercise(() -> {
            this.contentProvider.refreshElements();
            this.startMeasuring();
            this.contentProvider.cloneElements();
            this.contentProvider.preSortElements((Viewer)this.viewer, sorter);
            this.viewer.refresh();
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testUpdate() throws Throwable {
        this.openBrowser();
        TableViewerRefreshTest.exercise(() -> {
            TableItem[] items = this.viewer.getTable().getItems();
            this.startMeasuring();
            int j = 0;
            while (j < items.length) {
                TableItem item = items[j];
                TestElement element = RefreshTestContentProvider.allElements[j];
                this.viewer.testUpdateItem((Widget)item, element);
                ++j;
            }
            UITestUtil.processEvents();
            this.stopMeasuring();
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    class TestTableViewer
    extends TableViewer {
        public TestTableViewer(Composite parent, int style) {
            super(parent, style);
        }

        public TestTableViewer(Composite parent) {
            super(parent);
        }

        public TestTableViewer(Table table) {
            super(table);
        }

        public void testUpdateItem(Widget widget, Object element) {
            this.updateItem(widget, element);
        }
    }
}

