/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.TreeTest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Test;

public class TreeAddTest
extends TreeTest {
    static int TEST_COUNT = 1000;

    @Test
    public void testAddOneAtATime() {
        this.openBrowser();
        int i = 0;
        while (i < ITERATIONS / 10) {
            TestTreeElement input = new TestTreeElement(0, null);
            this.viewer.setInput((Object)input);
            input.createChildren(TEST_COUNT);
            UITestUtil.processEvents();
            this.startMeasuring();
            TestTreeElement[] testTreeElementArray = input.children;
            int n = input.children.length;
            int n2 = 0;
            while (n2 < n) {
                TestTreeElement child = testTreeElementArray[n2];
                this.viewer.add((Object)input, (Object)child);
                UITestUtil.processEvents();
                ++n2;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testAddTen() throws CoreException {
        this.doTestAdd(10, TEST_COUNT, false);
    }

    @Test
    public void testAddFifty() throws CoreException {
        this.doTestAdd(50, TEST_COUNT, false);
    }

    @Test
    public void testAddHundred() throws CoreException {
        this.doTestAdd(100, TEST_COUNT, false);
    }

    protected void doTestAdd(int increment, int total, boolean preSort) throws CoreException {
        this.openBrowser();
        TreeAddTest.exercise(() -> {
            TestTreeElement input = new TestTreeElement(0, null);
            this.viewer.setInput((Object)input);
            input.createChildren(total);
            if (preSort) {
                this.viewer.getComparator().sort((Viewer)this.viewer, (Object[])input.children);
            }
            ArrayList<Object[]> batches = new ArrayList<Object[]>();
            int blocks = input.children.length / increment;
            int j = 0;
            while (j < blocks) {
                Object[] batch1 = new Object[increment];
                System.arraycopy(input.children, j * increment, batch1, 0, increment);
                batches.add(batch1);
                j += increment;
            }
            UITestUtil.processEvents();
            Object[] batchArray = batches.toArray();
            this.startMeasuring();
            Object[] objectArray = batchArray;
            int n3 = batchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object batch2 = objectArray[n4];
                this.viewer.add((Object)input, (Object[])batch2);
                UITestUtil.processEvents();
                ++n4;
            }
            this.stopMeasuring();
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public void testAddThousand() throws CoreException {
        this.doTestAdd(1000, 2000, false);
    }

    @Test
    public void testAddTwoThousand() throws CoreException {
        this.doTestAdd(2000, 4000, false);
    }

    @Test
    public void testAddHundredPreSort() throws CoreException {
        this.doTestAdd(100, 1000, true);
    }

    @Test
    public void testAddThousandPreSort() throws CoreException {
        this.tagAsGlobalSummary("JFace - Add 2000 items in 2 blocks to TreeViewer", Dimension.ELAPSED_PROCESS);
        this.doTestAdd(1000, 2000, true);
    }
}

