/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.ViewerTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class TreeTest
extends ViewerTest {
    TreeViewer viewer;

    @Override
    protected StructuredViewer createViewer(Shell shell) {
        this.viewer = this.createTreeViewer(shell);
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setUseHashlookup(true);
        return this.viewer;
    }

    protected TreeViewer createTreeViewer(Shell shell) {
        return new TreeViewer((Composite)shell);
    }

    @Override
    protected Object getInitialInput() {
        return new TestTreeElement(0, null);
    }

    private IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                TestTreeElement element = (TestTreeElement)parentElement;
                return element.children;
            }

            public Object getParent(Object element) {
                return ((TestTreeElement)element).parent;
            }

            public boolean hasChildren(Object element) {
                return ((TestTreeElement)element).children.length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer localViewer, Object oldInput, Object newInput) {
            }
        };
    }
}

