/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.PerformanceTestCaseJunit4;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.CloseTestWindowsRule;
import org.junit.Rule;
import org.junit.function.ThrowingRunnable;
import org.osgi.framework.FrameworkUtil;

public abstract class BasicPerformanceTest
extends PerformanceTestCaseJunit4 {
    @Rule
    public final CloseTestWindowsRule closeTestWindows = new CloseTestWindowsRule();

    public static void waitForBackgroundJobs() {
        Job backgroundJob = new Job("This is a test job which sits around being low priority until everything else finishes"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        backgroundJob.setPriority(50);
        boolean hadEvents = true;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (hadEvents) {
                hadEvents = false;
                backgroundJob.schedule(0L);
                try {
                    backgroundJob.join();
                }
                catch (InterruptedException interruptedException) {}
                while (display.readAndDispatch()) {
                    hadEvents = true;
                }
            }
        }
    }

    public static void exercise(ThrowingRunnable runnable) throws CoreException {
        BasicPerformanceTest.exercise(runnable, 3, 100, 4000);
    }

    public static void exercise(ThrowingRunnable runnable, int minIterations, int maxIterations, int maxTime) throws CoreException {
        long startTime = System.currentTimeMillis();
        int counter = 0;
        while (counter < maxIterations) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throw new CoreException((IStatus)new Status(4, FrameworkUtil.getBundle(BasicPerformanceTest.class).getSymbolicName(), 0, "An exception occurred", e));
            }
            long curTime = System.currentTimeMillis();
            if (curTime - startTime > (long)maxTime && counter >= minIterations - 1) break;
            ++counter;
        }
    }
}

