/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public final class CommandsPerformanceTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private BindingManager bindingManager = null;
    private CommandManager commandManager = null;
    private ContextManager contextManager = null;

    private static final void createContext(ContextManager contextManager, String parent, int successors, List<String> activeContextIds) {
        int count = activeContextIds.size();
        String contextString = "context" + count;
        Context context = contextManager.getContext(contextString);
        context.define(contextString, contextString, parent);
        activeContextIds.add(contextString);
        if (successors == 0) {
            return;
        }
        CommandsPerformanceTest.createContext(contextManager, contextString, successors - 1, activeContextIds);
    }

    private static final void createScheme(BindingManager bindingManager, String parent, int successors, List<Scheme> schemes) {
        int count = schemes.size();
        String schemeString = "scheme" + count;
        Scheme scheme = bindingManager.getScheme(schemeString);
        scheme.define(schemeString, schemeString, parent);
        schemes.add(scheme);
        if (successors == 0) {
            return;
        }
        CommandsPerformanceTest.createScheme(bindingManager, schemeString, successors - 1, schemes);
    }

    @Before
    public final void setUpBindings() throws NotDefinedException, Exception {
        KeySequence keySequence;
        KeyStroke keyStroke;
        int modifierKeys;
        char character;
        String platform;
        String locale;
        int contextTreeDepth = 40;
        int schemeDepth = 20;
        int bindingCount = 5000;
        int platformLocaleCount = 1400;
        int deletionMarkers = 500;
        String currentLocale = Locale.getDefault().toString();
        String currentPlatform = Util.getWS();
        IKeyLookup lookup = KeyLookupFactory.getDefault();
        boolean modifierKeys0 = false;
        int modifierKeys1 = lookup.getAlt();
        int modifierKeys2 = lookup.getCommand();
        int modifierKeys3 = lookup.getCtrl();
        int modifierKeys4 = lookup.getShift();
        int modifierKeys5 = lookup.getAlt() | lookup.getCommand();
        int modifierKeys6 = lookup.getAlt() | lookup.getCtrl();
        int modifierKeys7 = lookup.getAlt() | lookup.getShift();
        int modifierKeys8 = lookup.getCommand() | lookup.getCtrl();
        int modifierKeys9 = lookup.getCommand() | lookup.getShift();
        int modifierKeys10 = lookup.getCtrl() | lookup.getShift();
        int modifierKeys11 = lookup.getAlt() | lookup.getCommand() | lookup.getCtrl();
        int modifierKeys12 = lookup.getAlt() | lookup.getCommand() | lookup.getShift();
        int modifierKeys13 = lookup.getAlt() | lookup.getCtrl() | lookup.getShift();
        int modifierKeys14 = lookup.getCommand() | lookup.getCtrl() | lookup.getShift();
        int modifierKeys15 = lookup.getAlt() | lookup.getCommand() | lookup.getCtrl() | lookup.getShift();
        int[] nArray = new int[16];
        nArray[1] = modifierKeys1;
        nArray[2] = modifierKeys2;
        nArray[3] = modifierKeys3;
        nArray[4] = modifierKeys4;
        nArray[5] = modifierKeys5;
        nArray[6] = modifierKeys6;
        nArray[7] = modifierKeys7;
        nArray[8] = modifierKeys8;
        nArray[9] = modifierKeys9;
        nArray[10] = modifierKeys10;
        nArray[11] = modifierKeys11;
        nArray[12] = modifierKeys12;
        nArray[13] = modifierKeys13;
        nArray[14] = modifierKeys14;
        nArray[15] = modifierKeys15;
        int[] modifierKeyTable = nArray;
        this.commandManager = new CommandManager();
        this.contextManager = new ContextManager();
        ArrayList<String> activeContextIds = new ArrayList<String>();
        CommandsPerformanceTest.createContext(this.contextManager, null, 40, activeContextIds);
        this.contextManager.setActiveContextIds(new HashSet<String>(activeContextIds));
        this.bindingManager = new BindingManager(this.contextManager, this.commandManager);
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        CommandsPerformanceTest.createScheme(this.bindingManager, null, 20, schemes);
        this.bindingManager.setActiveScheme((Scheme)schemes.get(schemes.size() - 1));
        Binding[] bindings = new Binding[5000];
        int i = 0;
        while (i < 500) {
            locale = null;
            platform = null;
            if (i < 1400) {
                switch (i % 4) {
                    case 0: {
                        locale = currentLocale;
                        break;
                    }
                    case 1: {
                        platform = currentPlatform;
                        break;
                    }
                    case 2: {
                        locale = "gibberish";
                        break;
                    }
                    case 3: {
                        platform = "gibberish";
                    }
                }
            }
            character = (char)(65 + i % 26);
            modifierKeys = modifierKeyTable[i / 26 % modifierKeyTable.length];
            keyStroke = KeyStroke.getInstance((int)modifierKeys, (int)character);
            keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
            String schemeId = ((Scheme)schemes.get(i % schemes.size())).getId();
            String contextId = (String)activeContextIds.get(i % activeContextIds.size());
            int type = i % 2;
            KeyBinding binding = new KeyBinding(keySequence, null, schemeId, contextId, locale, platform, null, type);
            bindings[i] = binding;
            ++i;
        }
        i = 0;
        while (i < 4500) {
            locale = null;
            platform = null;
            if (i > 500 && i < 1400) {
                switch (i % 4) {
                    case 0: {
                        locale = currentLocale;
                        break;
                    }
                    case 1: {
                        platform = currentPlatform;
                        break;
                    }
                    case 2: {
                        locale = "gibberish";
                        break;
                    }
                    case 3: {
                        platform = "gibberish";
                    }
                }
            }
            character = (char)(65 + i % 26);
            modifierKeys = modifierKeyTable[i / 26 % modifierKeyTable.length];
            keyStroke = KeyStroke.getInstance((int)modifierKeys, (int)character);
            keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
            String commandId = "command" + i;
            String schemeId = ((Scheme)schemes.get(i % schemes.size())).getId();
            String contextId = (String)activeContextIds.get(i % activeContextIds.size());
            int type = i % 2;
            Command command = this.commandManager.getCommand(commandId);
            ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
            KeyBinding binding = new KeyBinding(keySequence, parameterizedCommand, schemeId, contextId, locale, platform, null, type);
            bindings[i + 500] = binding;
            ++i;
        }
        this.bindingManager.setBindings(bindings);
    }

    @After
    public final void clearBindings() throws Exception {
        this.bindingManager = null;
        this.commandManager = null;
        this.contextManager = null;
    }

    @Test
    public final void testBindingCacheHitHard() throws ParseException {
        int cacheHits = 1000000;
        KeySequence keySequence = KeySequence.getInstance((String)"CTRL+F");
        this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
        this.startMeasuring();
        int i = 0;
        while (i < 1000000) {
            this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public final void testBindingCacheHitHardReverse() throws ParseException {
        int cacheHits = 1000000;
        KeySequence keySequence = KeySequence.getInstance((String)"CTRL+F");
        this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
        this.startMeasuring();
        int i = 0;
        while (i < 1000000) {
            this.bindingManager.getActiveBindingsFor(null);
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public final void testBindingCacheHitSoft() throws ParseException {
        int cacheHits = 10000;
        KeySequence keySequence = KeySequence.getInstance((String)"CTRL+F");
        Set contextSet1 = this.contextManager.getActiveContextIds();
        this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
        ArrayList contextList = new ArrayList(contextSet1);
        contextList.remove(contextList.size() - 1);
        HashSet contextSet2 = new HashSet(contextList);
        this.contextManager.setActiveContextIds(contextSet2);
        this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
        this.startMeasuring();
        int i = 0;
        while (i < 10000) {
            if (i % 2 == 0) {
                this.contextManager.setActiveContextIds(contextSet1);
            } else {
                this.contextManager.setActiveContextIds(contextSet2);
            }
            this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    @Test
    public final void testBindingCacheMissLarge() throws ParseException {
        KeySequence keySequence = KeySequence.getInstance((String)"CTRL+F");
        this.startMeasuring();
        this.bindingManager.getPartialMatches((TriggerSequence)keySequence);
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }
}

