/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EditorSwitchTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String extension1;
    private final String extension2;

    @Parameterized.Parameters(name="{index}: {0} - {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"perf_outline", "java"}, {"perf_basic", "perf_outline"});
    }

    public EditorSwitchTest(String extension1, String extension2) {
        this.extension1 = extension1;
        this.extension2 = extension2;
    }

    @Test
    public void test() throws CoreException {
        IWorkbenchWindow window = UITestUtil.openTestWindow((String)"org.eclipse.ui.tests.performancePerspective1");
        IWorkbenchPage activePage = window.getActivePage();
        IFile file1 = UIPerformanceTestRule.getTestProject().getFile("1." + this.extension1);
        Assert.assertTrue((boolean)file1.exists());
        IFile file2 = UIPerformanceTestRule.getTestProject().getFile("1." + this.extension2);
        Assert.assertTrue((boolean)file2.exists());
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file1, (boolean)true);
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file2, (boolean)true);
        UITestUtil.processEvents();
        EditorTestHelper.calmDown(500L, 30000L, 500L);
        EditorSwitchTest.waitForBackgroundJobs();
        int j = 0;
        while (j < 100) {
            this.startMeasuring();
            int i = 0;
            while (i < 12) {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file1, (boolean)true);
                UITestUtil.processEvents();
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file2, (boolean)true);
                UITestUtil.processEvents();
                ++i;
            }
            this.stopMeasuring();
            EditorTestHelper.calmDown(500L, 30000L, 100L);
            ++j;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

