/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenCloseEditorTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String extension;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"perf_basic"}, {"perf_outline"}, {"java"});
    }

    public OpenCloseEditorTest(String extension) {
        this.extension = extension;
    }

    @Test
    public void test() throws Throwable {
        IFile file = UIPerformanceTestRule.getTestProject().getFile("1." + this.extension);
        Assert.assertTrue((boolean)file.exists());
        IWorkbenchWindow window = UITestUtil.openTestWindow((String)"org.eclipse.ui.tests.performancePerspective1");
        IWorkbenchPage activePage = window.getActivePage();
        OpenCloseEditorTest.exercise(() -> {
            this.startMeasuring();
            int j = 0;
            while (j < 10) {
                IEditorPart part;
                try {
                    part = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    throw new AssertionError((Object)("Can't open editor for " + file.getName()));
                }
                UITestUtil.processEvents();
                activePage.closeEditor(part, false);
                UITestUtil.processEvents();
                ++j;
            }
            this.stopMeasuring();
        });
        if (this.extension.equals("java")) {
            this.tagAsSummary("UI - Open/Close Editor", Dimension.ELAPSED_PROCESS);
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

