/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenClosePerspectiveTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String id;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org.eclipse.ui.tests.harness.util.EmptyPerspective2"}, {"org.eclipse.ui.tests.performancePerspective1"}, {"org.eclipse.ui.resourcePerspective"}, {"org.eclipse.jdt.ui.JavaPerspective"}, {"org.eclipse.debug.ui.DebugPerspective"});
    }

    public OpenClosePerspectiveTest(String id) {
        this.id = id;
    }

    @Test
    public void test() throws Throwable {
        IPerspectiveRegistry registry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective1 = registry.findPerspectiveWithId(this.id);
        if (perspective1 == null) {
            System.out.println("Unknown perspective id: " + this.id);
            return;
        }
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        IWorkbenchPage activePage = window.getActivePage();
        activePage.setPerspective(perspective1);
        IViewReference[] refs = activePage.getViewReferences();
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getId();
            ++i;
        }
        this.closePerspective(activePage);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String i2 = stringArray[n2];
            activePage.showView(i2);
            ++n2;
        }
        if (this.id.equals("org.eclipse.ui.tests.performancePerspective1")) {
            this.tagAsSummary("UI - Open/Close " + perspective1.getLabel() + " Perspective", Dimension.ELAPSED_PROCESS);
        }
        OpenClosePerspectiveTest.exercise(() -> {
            UITestUtil.processEvents();
            EditorTestHelper.calmDown(500L, 30000L, 500L);
            this.startMeasuring();
            activePage.setPerspective(perspective1);
            UITestUtil.processEvents();
            this.closePerspective(activePage);
            UITestUtil.processEvents();
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void closePerspective(IWorkbenchPage activePage) {
        IPerspectiveDescriptor persp = activePage.getPerspective();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.closePerspective");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.eclipse.ui.window.closePerspective.perspectiveId", persp.getId());
        ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(pCommand, null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
            // empty catch block
        }
    }
}

