/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenCloseWindowTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String id;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org.eclipse.ui.tests.harness.util.EmptyPerspective2"}, {"org.eclipse.ui.tests.performancePerspective1"}, {"org.eclipse.ui.resourcePerspective"}, {"org.eclipse.jdt.ui.JavaPerspective"}, {"org.eclipse.debug.ui.DebugPerspective"});
    }

    public OpenCloseWindowTest(String id) {
        this.id = id;
    }

    @Test
    public void test() throws Throwable {
        OpenCloseWindowTest.exercise(() -> {
            UITestUtil.processEvents();
            EditorTestHelper.calmDown(500L, 30000L, 500L);
            this.startMeasuring();
            IWorkbenchWindow window = UITestUtil.openTestWindow((String)this.id);
            UITestUtil.processEvents();
            window.close();
            UITestUtil.processEvents();
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
    }
}

