/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenMultipleEditorTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String extension;
    private final boolean closeAll;

    @Parameterized.Parameters(name="{index}: closeAll: {0} - closeEach: {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"perf_basic", true}, {"perf_outline", true}, {"java", true}, {"perf_basic", false}, {"perf_outline", false}, {"java", false});
    }

    public OpenMultipleEditorTest(String extension, boolean closeAll) {
        this.extension = extension;
        this.closeAll = closeAll;
    }

    @Test
    public void test() throws Throwable {
        IWorkbenchWindow window = UITestUtil.openTestWindow((String)"org.eclipse.ui.tests.performancePerspective1");
        IWorkbenchPage activePage = window.getActivePage();
        this.startMeasuring();
        int i = 0;
        while (i < 100) {
            IFile file = UIPerformanceTestRule.getTestProject().getFile(i + "." + this.extension);
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
            UITestUtil.processEvents();
            ++i;
        }
        if (this.closeAll) {
            activePage.closeAllEditors(false);
        } else {
            IEditorReference[] parts;
            IEditorReference[] iEditorReferenceArray = parts = activePage.getEditorReferences();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference part = iEditorReferenceArray[n2];
                activePage.closeEditor(part.getEditor(false), false);
                ++n2;
            }
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }
}

