/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.performance.PerformanceTestCaseJunit4;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class OpenProjectExplorerFolderTest
extends PerformanceTestCaseJunit4 {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();

    @Test
    public void testOpenNavigatorFolder() {
        IProject project = this.createProject("testViewAndContentTypeProject");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.tests.performance");
        URL url = bundle.getEntry("data/testContentType.zip");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipInputStream zis = new ZipInputStream(url.openStream());){
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    Throwable throwable2;
                    byte[] content = new byte[]{};
                    try {
                        Throwable throwable3 = null;
                        throwable2 = null;
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            byte[] b = new byte[2048];
                            int read = zis.read(b);
                            while (read != -1) {
                                baos.write(b, 0, read);
                                read = zis.read(b);
                            }
                            content = baos.toByteArray();
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    IFile file = project.getFile(entry.getName());
                    try {
                        throwable2 = null;
                        Object var11_21 = null;
                        try (ByteArrayInputStream bais = new ByteArrayInputStream(content);){
                            if (!file.exists()) {
                                file.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
                            } else {
                                file.setContents((InputStream)bais, true, false, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (CoreException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        this.startMeasuring();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        try {
            view = activePage.showView("org.eclipse.ui.navigator.ProjectExplorer");
        }
        catch (PartInitException e) {
            Assert.fail((String)e.getMessage());
        }
        ProjectExplorer projectExplorer = null;
        try {
            projectExplorer = (ProjectExplorer)view;
        }
        catch (ClassCastException e) {
            Assert.fail((String)e.getMessage());
        }
        projectExplorer.getCommonViewer().expandAll();
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    private IProject createProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        return project;
    }
}

