/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PerspectiveSwitchTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    private final String id1;
    private final String id2;
    private final String activeEditor;

    @Parameterized.Parameters(name="{index}: {0}, {1}, editor {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.debug.ui.DebugPerspective", "1.java"}, {"org.eclipse.ui.tests.performancePerspective1", "org.eclipse.ui.tests.performancePerspective2", "1.perf_basic"}, {"org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.ui.tests.util.EmptyPerspective", "1.perf_basic"}, {"org.eclipse.ui.resourcePerspective", "org.eclipse.jdt.ui.JavaPerspective", "1.java"});
    }

    public PerspectiveSwitchTest(String id1, String id2, String activeEditor) {
        this.id1 = id1;
        this.id2 = id2;
        this.activeEditor = activeEditor;
    }

    @Test
    public void test() throws CoreException, WorkbenchException {
        IPerspectiveRegistry registry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective1 = registry.findPerspectiveWithId(this.id1);
        IPerspectiveDescriptor perspective2 = registry.findPerspectiveWithId(this.id2);
        if (perspective1 == null) {
            System.out.println("Unknown perspective ID: " + this.id1);
            return;
        }
        if (perspective2 == null) {
            System.out.println("Unknown perspective ID: " + this.id2);
            return;
        }
        IWorkbenchWindow window = UITestUtil.openTestWindow((String)this.id1);
        IWorkbenchPage page = window.getActivePage();
        Assert.assertNotNull((Object)page);
        page.setPerspective(perspective2);
        IFile aFile = UIPerformanceTestRule.getTestProject().getFile(this.activeEditor);
        Assert.assertTrue((boolean)aFile.exists());
        IDE.openEditor((IWorkbenchPage)page, (IFile)aFile, (boolean)true);
        PerspectiveSwitchTest.exercise(() -> {
            UITestUtil.processEvents();
            this.startMeasuring();
            page.setPerspective(perspective1);
            UITestUtil.processEvents();
            page.setPerspective(perspective2);
            UITestUtil.processEvents();
            this.stopMeasuring();
        });
        this.commitMeasurements();
        this.assertPerformance();
    }
}

