/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.parts.PerformanceProblemsView;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.junit.Assert;
import org.junit.Test;

public class ProblemsViewPerformanceTest
extends BasicPerformanceTest {
    private final String EMPTY_PERSPECTIVE_ID = "org.eclipse.ui.tests.harness.util.EmptyPerspective";
    private final String PROBLEMS_VIEW_ID = "org.eclipse.ui.tests.performance.problemsView";

    @Test
    public void testPopulation() {
        PerformanceProblemsView view;
        IWorkbenchWindow window = UITestUtil.openTestWindow((String)"org.eclipse.ui.tests.harness.util.EmptyPerspective");
        IWorkbenchPage page = window.getActivePage();
        try {
            view = (PerformanceProblemsView)page.showView("org.eclipse.ui.tests.performance.problemsView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            Assert.fail();
            return;
        }
        int i = 0;
        while (i < 100) {
            this.createMarkers();
            UITestUtil.processEvents();
            this.startMeasuring();
            while (view.getTreeWidget().getItemCount() == 0) {
                UITestUtil.processEvents();
            }
            this.stopMeasuring();
            this.removeMarkers();
            while (view.getTreeWidget().getItemCount() > 0) {
                UITestUtil.processEvents();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void removeMarkers() {
        try {
            IMarker[] markers;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMarker[] iMarkerArray = markers = root.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String message = (String)marker.getAttribute("message");
                if (message != null && message.startsWith("this is a test")) {
                    marker.delete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createMarkers() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            HashMap<String, Object> attribs = new HashMap<String, Object>();
            int i = 0;
            while (i < 1000) {
                attribs.put("severity", 2);
                attribs.put("message", "this is a test " + i);
                MarkerUtilities.createMarker((IResource)root, attribs, (String)"org.eclipse.core.resources.problemmarker");
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

