/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.harness.util.PreferenceMementoRule;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.UIPerformanceTestRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ProgressReportingTest
extends BasicPerformanceTest {
    @ClassRule
    public static final UIPerformanceTestRule uiPerformanceTestRule = new UIPerformanceTestRule();
    public static final int ITERATIONS = 10000000;
    public static final int VERY_SLOW_OPERATION_ITERATIONS = 100000;
    public static final int MAX_RUNTIME = 4000;
    public static final int MAX_ITERATIONS = 100;
    @Rule
    public final PreferenceMementoRule preferenceMemento = new PreferenceMementoRule();
    private volatile boolean isDone;
    private Display display;

    @Before
    public final void storeDisplay() throws Exception {
        this.display = Display.getCurrent();
    }

    private void setRunInBackground(boolean newRunInBackgroundSetting) {
        this.preferenceMemento.setPreference(WorkbenchPlugin.getDefault().getPreferenceStore(), "RUN_IN_BACKGROUND", (Object)newRunInBackgroundSetting);
    }

    public void runAsyncTest(Runnable testContent) throws Exception {
        Display display = Display.getCurrent();
        ProgressReportingTest.exercise(() -> {
            this.startMeasuring();
            this.isDone = false;
            testContent.run();
            while (!this.isDone) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.stopMeasuring();
        }, 1, 100, 4000);
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void endAsyncTest() {
        this.isDone = true;
        this.display.asyncExec(() -> {});
    }

    @Test
    public void testJobNoMonitorUsage() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            int i = 0;
            while (i < 10000000) {
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobSetTaskName() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            while (i < 10000000) {
                monitor.setTaskName(Integer.toString(i));
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobSubTask() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            while (i < 10000000) {
                monitor.subTask(Integer.toString(i));
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobIsCanceled() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            while (i < 10000000) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobWorked() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            while (i < 10000000) {
                monitor.worked(1);
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobSubMonitorSplit() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            while (i < 10000000) {
                subMonitor.split(1);
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobSubMonitorNewChild() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            while (i < 10000000) {
                subMonitor.newChild(1);
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testJobSubMonitorWorked() throws Exception {
        UITestUtil.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            while (i < 10000000) {
                subMonitor.worked(1);
                ++i;
            }
            this.endAsyncTest();
        }).schedule());
    }

    @Test
    public void testRunInForegroundNoMonitorUsage() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                while (i < 100000) {
                    ++i;
                }
                this.endAsyncTest();
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    @Test
    public void testRunInForegroundWorked() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                while (i < 100000) {
                    monitor.worked(1);
                    ++i;
                }
                this.endAsyncTest();
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    @Test
    public void testRunInForegroundSetTaskName() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                while (i < 100000) {
                    monitor.setTaskName(Integer.toString(i));
                    ++i;
                }
                this.endAsyncTest();
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    @Test
    public void testRunInForegroundSubTask() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                while (i < 100000) {
                    monitor.subTask(Integer.toString(i));
                    ++i;
                }
                this.endAsyncTest();
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    @Test
    public void testRunInForegroundIsCanceled() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                while (i < 100000) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++i;
                }
                this.endAsyncTest();
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    @Test
    public void testProgressMonitorDialogNoMonitorUsage() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, monitor -> {
                    monitor.beginTask("Test Job", 10000000);
                    int i = 0;
                    while (i < 10000000) {
                        ++i;
                    }
                    this.endAsyncTest();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testProgressMonitorDialogWorked() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, monitor -> {
                    monitor.beginTask("Test Job", 10000000);
                    int i = 0;
                    while (i < 10000000) {
                        monitor.worked(1);
                        ++i;
                    }
                    this.endAsyncTest();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testProgressMonitorDialogIsCanceled() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, monitor -> {
                    monitor.beginTask("Test Job", 10000000);
                    int i = 0;
                    while (i < 10000000) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++i;
                    }
                    this.endAsyncTest();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testProgressMonitorDialogSetTaskName() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, monitor -> {
                    monitor.beginTask("Test Job", 10000000);
                    int i = 0;
                    while (i < 10000000) {
                        monitor.setTaskName(Integer.toString(i));
                        ++i;
                    }
                    this.endAsyncTest();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testProgressMonitorDialogSubTask() throws Exception {
        IWorkbenchWindow window = UITestUtil.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, monitor -> {
                    monitor.beginTask("Test Job", 10000000);
                    int i = 0;
                    while (i < 10000000) {
                        monitor.subTask(Integer.toString(i));
                        ++i;
                    }
                    this.endAsyncTest();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

