/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.tests.harness.util.FileTool;

public class ResourceTestHelper {
    public static void replicate(String src, String destPrefix, String destSuffix, int n) throws CoreException {
        int i = 0;
        while (i < n) {
            ResourceTestHelper.copy(src, destPrefix + i + destSuffix);
            ++i;
        }
    }

    public static void copy(String src, String dest) throws CoreException {
        IFile file = ResourceTestHelper.getRoot().getFile(IPath.fromOSString((String)src));
        file.copy(IPath.fromOSString((String)dest), true, null);
    }

    public static void delete(String file) throws CoreException {
        ResourceTestHelper.getRoot().getFile(IPath.fromOSString((String)file)).delete(true, null);
    }

    public static IFile findFile(String path) {
        return ResourceTestHelper.getRoot().getFile(IPath.fromOSString((String)path));
    }

    public static IFile[] findFiles(String prefix, String suffix, int i, int n) {
        IWorkspaceRoot root = ResourceTestHelper.getRoot();
        ArrayList<IFile> files = new ArrayList<IFile>(n - i);
        int j = i;
        while (j < i + n) {
            String path = root.getLocation().toString() + "/" + prefix + j + suffix;
            files.add(ResourceTestHelper.findFile(path));
            ++j;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static StringBuilder read(String src) throws IOException, CoreException {
        return FileTool.readToBuilder((Reader)new InputStreamReader(ResourceTestHelper.getRoot().getFile(IPath.fromOSString((String)src)).getContents()));
    }

    public static void write(String dest, String content) throws CoreException {
        InputStream stream = new InputStream(content){
            private final Reader fReader;
            {
                this.fReader = new StringReader(string);
            }

            @Override
            public int read() throws IOException {
                return this.fReader.read();
            }
        };
        ResourceTestHelper.getRoot().getFile(IPath.fromOSString((String)dest)).create(stream, true, null);
    }

    public static void replicate(String src, String destPrefix, String destSuffix, int n, String srcName, String destNamePrefix) throws IOException, CoreException {
        StringBuilder s = ResourceTestHelper.read(src);
        List<Integer> positions = ResourceTestHelper.identifierPositions(s, srcName);
        int j = 0;
        while (j < n) {
            StringBuilder c = new StringBuilder(s.toString());
            ResourceTestHelper.replacePositions(c, srcName.length(), destNamePrefix + j, positions);
            ResourceTestHelper.write(destPrefix + j + destSuffix, c.toString());
            ++j;
        }
    }

    public static void copy(String src, String dest, String srcName, String destName) throws IOException, CoreException {
        StringBuilder buf = ResourceTestHelper.read(src);
        List<Integer> positions = ResourceTestHelper.identifierPositions(buf, srcName);
        ResourceTestHelper.replacePositions(buf, srcName.length(), destName, positions);
        ResourceTestHelper.write(dest, buf.toString());
    }

    private static void replacePositions(StringBuilder c, int origLength, String string, List<Integer> positions) {
        int offset = 0;
        for (Integer integer : positions) {
            int position = integer;
            c.replace(offset + position, offset + position + origLength, string);
            offset += string.length() - origLength;
        }
    }

    private static List<Integer> identifierPositions(StringBuilder buffer, String identifier) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int i = -1;
        while ((i = buffer.indexOf(identifier, i + 1)) != -1) {
            if (i > 0 && Character.isJavaIdentifierPart(buffer.charAt(i - 1)) || i < buffer.length() - 1 && Character.isJavaIdentifierPart(buffer.charAt(i + identifier.length()))) continue;
            positions.add(i);
        }
        return positions;
    }

    private static IWorkspaceRoot getRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static boolean enableAutoBuilding() {
        boolean wasOff;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        boolean bl = wasOff = !description.isAutoBuilding();
        if (wasOff) {
            description.setAutoBuilding(true);
        }
        return wasOff;
    }

    public static void incrementalBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, null);
    }

    public static void fullBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, null);
    }

    public static boolean disableAutoBuilding() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        boolean wasOn = description.isAutoBuilding();
        if (wasOn) {
            description.setAutoBuilding(false);
        }
        return wasOn;
    }
}

