/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.ResourceTestHelper;
import org.junit.rules.ExternalResource;

public class UIPerformanceTestRule
extends ExternalResource {
    public static final String PERSPECTIVE1 = "org.eclipse.ui.tests.performancePerspective1";
    public static final String PERSPECTIVE2 = "org.eclipse.ui.tests.performancePerspective2";
    public static final String PROJECT_NAME = "Performance Project";
    private static final String INTRO_VIEW = "org.eclipse.ui.internal.introview";
    public static final String[] EDITOR_FILE_EXTENSIONS = new String[]{"perf_basic", "perf_outline", "java"};

    protected void before() throws Throwable {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        activePage.hideView(activePage.findViewReference(INTRO_VIEW));
        workbench.showPerspective(PERSPECTIVE1, activeWindow);
        boolean wasAutobuilding = ResourceTestHelper.disableAutoBuilding();
        UIPerformanceTestRule.setUpProject();
        ResourceTestHelper.fullBuild();
        if (wasAutobuilding) {
            ResourceTestHelper.enableAutoBuilding();
            EditorTestHelper.calmDown(2000L, 30000L, 1000L);
        }
    }

    protected void after() {
        try {
            UIPerformanceTestRule.getTestProject().delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IProject getTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }

    private static void setUpProject() throws CoreException {
        IProject testProject = UIPerformanceTestRule.getTestProject();
        testProject.create(null);
        testProject.open(null);
        String[] stringArray = EDITOR_FILE_EXTENSIONS;
        int n = EDITOR_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String EDITOR_FILE_EXTENSION = stringArray[n2];
            UIPerformanceTestRule.createFiles(testProject, EDITOR_FILE_EXTENSION);
            ++n2;
        }
    }

    private static void createFiles(IProject project, String ext) throws CoreException {
        int i = 0;
        while (i < 100) {
            String fileName = i + "." + ext;
            IFile iFile = project.getFile(fileName);
            iFile.create((InputStream)new ByteArrayInputStream(new byte[]{10}), true, null);
            ++i;
        }
    }
}

