/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;
import org.junit.Test;

public class LayoutTest
extends BasicPerformanceTest {
    private final TestWidgetFactory widgetFactory;
    private final int xIterations = 100;
    private final int yIterations = 10;
    private final boolean flushState;

    public LayoutTest(TestWidgetFactory widgetFactory, boolean flushState) {
        this.widgetFactory = widgetFactory;
        this.flushState = flushState;
    }

    @Test
    public void test() throws CoreException, WorkbenchException {
        this.widgetFactory.init();
        Composite widget = this.widgetFactory.getControl();
        Point maxSize = this.widgetFactory.getMaxSize();
        Rectangle initialBounds = widget.getBounds();
        Rectangle newBounds = Geometry.copy((Rectangle)initialBounds);
        int xIteration = 0;
        while (xIteration < 100) {
            UITestUtil.processEvents();
            this.startMeasuring();
            int yIteration = 0;
            while (yIteration < 10) {
                int xSize = maxSize.x * ((xIteration + yIteration) % 100) / 100;
                int ySize = maxSize.y * yIteration / 10;
                newBounds.width = xSize;
                newBounds.height = ySize;
                widget.setBounds(newBounds);
                widget.layout(this.flushState);
                ++yIteration;
            }
            this.stopMeasuring();
            ++xIteration;
        }
        this.commitMeasurements();
        this.assertPerformance();
        widget.setBounds(initialBounds);
        this.widgetFactory.done();
    }
}

