/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;
import org.junit.Assert;

public class PerspectiveWidgetFactory
extends TestWidgetFactory {
    private final String perspectiveId;
    private IWorkbenchWindow window;

    public PerspectiveWidgetFactory(String initialPerspective) {
        this.perspectiveId = initialPerspective;
    }

    @Override
    public Point getMaxSize() {
        return new Point(1024, 768);
    }

    @Override
    public void init() throws WorkbenchException {
        this.window = PlatformUI.getWorkbench().openWorkbenchWindow(this.perspectiveId, UITestUtil.getPageInput());
        IWorkbenchPage page = this.window.getActivePage();
        Assert.assertNotNull((Object)page);
    }

    @Override
    public String getName() {
        return "Perspective " + this.perspectiveId;
    }

    @Override
    public Composite getControl() {
        return this.window.getShell();
    }

    @Override
    public void done() {
        this.window.close();
    }
}

