/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;
import org.junit.Assert;

public class ViewWidgetFactory
extends TestWidgetFactory {
    private final String viewId;
    private Control ctrl;
    private IWorkbenchWindow window;

    public ViewWidgetFactory(String viewId) {
        this.viewId = viewId;
        Assert.assertNotNull((Object)viewId);
    }

    @Override
    public Point getMaxSize() {
        return new Point(1024, 768);
    }

    public static Composite getControl(IViewPart part) {
        ViewSite site = (ViewSite)part.getSite();
        MPart modelPart = site.getModel();
        return (Composite)modelPart.getWidget();
    }

    @Override
    public void init() throws WorkbenchException {
        this.window = PlatformUI.getWorkbench().openWorkbenchWindow("org.eclipse.ui.tests.harness.util.EmptyPerspective", UITestUtil.getPageInput());
        IWorkbenchPage page = this.window.getActivePage();
        Assert.assertNotNull((Object)page);
        IViewPart part = page.showView(this.viewId, null, 1);
        BasicPerformanceTest.waitForBackgroundJobs();
        this.ctrl = ViewWidgetFactory.getControl(part);
        Point size = this.getMaxSize();
        this.ctrl.setBounds(0, 0, size.x, size.y);
        this.window.getShell().setSize(size);
    }

    @Override
    public String getName() {
        return "View " + this.viewId;
    }

    @Override
    public Composite getControl() {
        return (Composite)this.ctrl;
    }

    @Override
    public void done() {
        this.window.close();
    }
}

