/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.contenttype.tests;

import java.util.Arrays;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UserContentTypeTest {
    private IContentType createdUserContentType;
    private IContentTypeManager manager;
    private IContentType[] initialContentTypes;

    @BeforeEach
    public void setUp() {
        this.createdUserContentType = null;
        this.manager = new ContentTypeManager();
        IContentType[] iContentTypeArray = this.initialContentTypes = this.manager.getAllContentTypes();
        int n = this.initialContentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            Assertions.assertThat((Object)contentType).matches(Predicate.not(IContentTypeSettings::isUserDefined), "is not user defined");
            ++n2;
        }
    }

    @AfterEach
    public void tearDown() throws CoreException {
        if (this.createdUserContentType != null) {
            this.manager.removeContentType(this.createdUserContentType.getId());
        }
        ContentTypeManager.shutdown();
    }

    @Test
    public void testCannotDeleteSystemContentType() {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.initialContentTypes).as("check has content type to try", new Object[0])).isNotEmpty();
        IContentType toDelete = this.initialContentTypes[0];
        Assertions.assertThat((Object)toDelete).matches(Predicate.not(IContentTypeSettings::isUserDefined), "is system and not user defined");
        Assertions.assertThatThrownBy(() -> this.manager.removeContentType(toDelete.getId())).isInstanceOf(IllegalArgumentException.class);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.getAllContentTypes()).as("check number of content types has not changed", new Object[0])).hasSameSizeAs((Object)this.initialContentTypes);
        ((ObjectAssert)Assertions.assertThat((Object)this.manager.getContentType(toDelete.getId())).as("check could access content type", new Object[0])).isEqualTo((Object)toDelete);
    }

    @Test
    public void testAddUserDefinedContentTypes() throws CoreException {
        String contentTypeIdentifier = "testContentType" + System.nanoTime();
        this.createdUserContentType = this.manager.addContentType(contentTypeIdentifier, "user-defined test content-type", null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.getAllContentTypes()).as("check content type is registered", new Object[0])).hasSize(this.initialContentTypes.length + 1);
        Assertions.assertThat((Object)this.createdUserContentType).matches(IContentTypeSettings::isUserDefined, "is user defined");
        Assertions.assertThat((Object)this.manager.getContentType(contentTypeIdentifier)).isEqualTo((Object)this.createdUserContentType);
        IContentType[] iContentTypeArray = this.manager.getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.equals(this.createdUserContentType)) {
                Assertions.assertThat((Object)contentType).matches(IContentTypeSettings::isUserDefined, "is user defined");
            } else {
                Assertions.assertThat((Object)contentType).matches(Predicate.not(IContentTypeSettings::isUserDefined), "is not user defined");
            }
            ++n2;
        }
    }

    @Test
    public void testPersistContentTypeAndAssociation() throws CoreException {
        this.testAddUserDefinedContentTypes();
        this.createdUserContentType.addFileSpec("fileSpec", 4);
        ContentTypeManager.shutdown();
        this.manager = new ContentTypeManager();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.manager.getAllContentTypes()).as("check content type is persisted", new Object[0])).hasSize(this.initialContentTypes.length + 1);
        this.createdUserContentType = this.manager.getContentType(this.createdUserContentType.getId());
        ((ObjectAssert)Assertions.assertThat((Object)this.createdUserContentType).as("find new content type in new manager", new Object[0])).isNotNull();
        Assertions.assertThat((Object)this.createdUserContentType).matches(IContentTypeSettings::isUserDefined, "is user defined");
        Assertions.assertThat((Object)this.createdUserContentType).matches(it -> Arrays.asList(it.getFileSpecs(4)).contains("fileSpec"), "has association persisted");
    }
}

