/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.preferences.tests;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class EclipsePreferencesTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testBundleStateScope() throws InvalidSyntaxException, IllegalStateException, MalformedURLException, IOException {
        Bundle bundle = FrameworkUtil.getBundle(EclipsePreferencesTest.class);
        Assert.assertNotNull((Object)bundle);
        BundleContext bundleContext = bundle.getBundleContext();
        Assert.assertNotNull((Object)bundleContext);
        this.initLocation(bundleContext);
        serviceTracker.open();
        try (ServiceTracker serviceTracker = new ServiceTracker(bundleContext, IScopeContext.class, null);){
            IScopeContext context = (IScopeContext)serviceTracker.getService();
            Assert.assertEquals((Object)InstanceScope.INSTANCE.getNode(bundle.getSymbolicName()), (Object)context.getNode(""));
            Assert.assertEquals((Object)Platform.getStateLocation((Bundle)bundle), (Object)context.getLocation());
        }
    }

    private void initLocation(BundleContext bundleContext) throws InvalidSyntaxException, IOException, MalformedURLException {
        serviceTracker.open();
        try (ServiceTracker serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(Location.INSTANCE_FILTER), null);){
            Location location = (Location)serviceTracker.getService();
            Assert.assertNotNull((Object)location);
            if (!location.isSet()) {
                location.set(this.folder.getRoot().toURI().toURL(), false);
            }
        }
    }

    @Test
    public void testConcurrentPreferenceChangeListener() throws InterruptedException, CoreException {
        IEclipsePreferences node = EclipsePreferencesTest.createTestNode();
        int runSize = 100000;
        EclipsePreferencesTest.executeInTwoThreads(monitor -> {
            IEclipsePreferences.IPreferenceChangeListener listener = event -> {};
            int i = 0;
            while (i < 100000 && !monitor.isCanceled()) {
                node.addPreferenceChangeListener(listener);
                node.put("x", "y");
                node.remove("x");
                node.removePreferenceChangeListener(listener);
                ++i;
            }
        });
    }

    @Test
    public void testConcurrentNodeChangeListener() throws InterruptedException, CoreException {
        IEclipsePreferences node = EclipsePreferencesTest.createTestNode();
        int runSize = 100000;
        EclipsePreferencesTest.executeInTwoThreads(monitor -> {
            IEclipsePreferences.INodeChangeListener listener = new IEclipsePreferences.INodeChangeListener(){

                public void removed(IEclipsePreferences.NodeChangeEvent event) {
                }

                public void added(IEclipsePreferences.NodeChangeEvent event) {
                }
            };
            int i = 0;
            while (i < 100000 && !monitor.isCanceled()) {
                node.addNodeChangeListener(listener);
                try {
                    node.node(Thread.currentThread().getName()).removeNode();
                }
                catch (BackingStoreException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.runtime", 0, "", null));
                }
                node.removeNodeChangeListener(listener);
                ++i;
            }
        });
    }

    private static void executeInTwoThreads(ICoreRunnable runnable) throws InterruptedException, CoreException {
        CountDownLatch latch = new CountDownLatch(1);
        Job job = Job.create((String)"", monitor -> {
            latch.countDown();
            runnable.run(monitor);
        });
        job.schedule();
        try {
            latch.await();
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            job.cancel();
            job.join();
            IStatus result = job.getResult();
            Assert.assertNotNull((String)"Job is expected to complete", (Object)result);
            if (!result.isOK()) {
                throw new CoreException(result);
            }
        }
    }

    @After
    public void after() throws BackingStoreException {
        EclipsePreferencesTest.getScopeRoot().removeNode();
    }

    private static String getUniqueString() {
        return System.currentTimeMillis() + "-" + Math.random();
    }

    private static IEclipsePreferences createTestNode() {
        return (IEclipsePreferences)EclipsePreferencesTest.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
    }

    private static IEclipsePreferences getScopeRoot() {
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("EclipsePreferencesTest");
    }
}

