/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.preferences.tests;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.junit.Assert;
import org.junit.Test;

public class OsgiPreferenceMetadataStoreTest {
    private final PreferenceMetadata<Object> unknown = new PreferenceMetadata(Object.class, "unknown", (Object)"", "Unknown", "An option with unclear semantic, i.e. typical one");
    private final PreferenceMetadata<String> string2020 = new PreferenceMetadata(String.class, "string2020", (Object)"2020", "String 2020");
    private final PreferenceMetadata<Boolean> negative = new PreferenceMetadata(Boolean.class, "negative", (Object)false, "Negative");
    private final PreferenceMetadata<Boolean> positive = new PreferenceMetadata(Boolean.class, "positive", (Object)true, "Positive");
    private final PreferenceMetadata<byte[]> bytes2020 = new PreferenceMetadata(byte[].class, "bytes2020", (Object)new byte[]{20, 20}, "Bytes 2020");
    private final PreferenceMetadata<Double> double2020 = new PreferenceMetadata(Double.class, "double2020", (Object)2020.0, "Double 2020");
    private final PreferenceMetadata<Float> float2020 = new PreferenceMetadata(Float.class, "float2020", (Object)Float.valueOf(2020.0f), "Float 2020");
    private final PreferenceMetadata<Integer> int2020 = new PreferenceMetadata(Integer.class, "int2020", (Object)2020, "Int 2020");
    private final PreferenceMetadata<Long> long2020 = new PreferenceMetadata(Long.class, "long2020", (Object)2020L, "Long 2020");

    @Test(expected=NullPointerException.class)
    public void testNullPreferences() {
        new OsgiPreferenceMetadataStore(null);
    }

    @Test
    public void testConsumable() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        Assert.assertFalse((boolean)storage.handles(Object.class));
        Assert.assertTrue((boolean)storage.handles(String.class));
        Assert.assertTrue((boolean)storage.handles(Boolean.class));
        Assert.assertTrue((boolean)storage.handles(byte[].class));
        Assert.assertFalse((boolean)storage.handles(Byte[].class));
        Assert.assertTrue((boolean)storage.handles(Double.class));
        Assert.assertTrue((boolean)storage.handles(Float.class));
        Assert.assertTrue((boolean)storage.handles(Integer.class));
        Assert.assertTrue((boolean)storage.handles(Long.class));
    }

    @Test
    public void testLoadString() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.put(this.string2020.identifer(), "2002");
        Assert.assertEquals((Object)"2002", (Object)storage.load(this.string2020));
    }

    @Test
    public void testLoadBoolean() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putBoolean(this.negative.identifer(), true);
        Assert.assertEquals((Object)true, (Object)storage.load(this.negative));
        preferences.putBoolean(this.positive.identifer(), false);
        Assert.assertEquals((Object)false, (Object)storage.load(this.positive));
    }

    @Test
    public void testLoadByteArray() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putByteArray(this.bytes2020.identifer(), new byte[]{20, 2});
        Assert.assertArrayEquals((byte[])new byte[]{20, 2}, (byte[])((byte[])storage.load(this.bytes2020)));
    }

    @Test
    public void testLoadDouble() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putDouble(this.double2020.identifer(), 2002.0);
        Assert.assertEquals((double)2002.0, (double)((Double)storage.load(this.double2020)), (double)0.0);
    }

    @Test
    public void testLoadFloat() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putFloat(this.float2020.identifer(), 2002.0f);
        Assert.assertEquals((float)2002.0f, (float)((Float)storage.load(this.float2020)).floatValue(), (float)0.0f);
    }

    @Test
    public void testLoadInt() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putLong(this.int2020.identifer(), 2002L);
        Assert.assertEquals((long)2002L, (long)((Integer)storage.load(this.int2020)).intValue());
    }

    @Test
    public void testLoadLong() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        preferences.putLong(this.long2020.identifer(), 2002L);
        Assert.assertEquals((long)2002L, (long)((Long)storage.load(this.long2020)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLoadUnknown() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        Assert.assertEquals((Object)new Object(), (Object)storage.load(this.unknown));
    }

    @Test
    public void testSaveString() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)"2002", this.string2020);
        Assert.assertEquals((Object)"2002", (Object)preferences.get(this.string2020.identifer(), (String)this.string2020.defaultValue()));
    }

    @Test
    public void testSaveBoolean() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)true, this.negative);
        Assert.assertEquals((Object)true, (Object)preferences.getBoolean(this.negative.identifer(), ((Boolean)this.negative.defaultValue()).booleanValue()));
        storage.save((Object)false, this.positive);
        Assert.assertEquals((Object)false, (Object)preferences.getBoolean(this.positive.identifer(), ((Boolean)this.positive.defaultValue()).booleanValue()));
    }

    @Test
    public void testSaveByteArray() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)new byte[]{20, 2}, this.bytes2020);
        Assert.assertArrayEquals((byte[])new byte[]{20, 2}, (byte[])preferences.getByteArray(this.bytes2020.identifer(), (byte[])this.bytes2020.defaultValue()));
    }

    @Test
    public void testSaveDouble() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)2002.0, this.double2020);
        Assert.assertEquals((double)2002.0, (double)preferences.getDouble(this.double2020.identifer(), ((Double)this.double2020.defaultValue()).doubleValue()), (double)0.0);
    }

    @Test
    public void testSaveFloat() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)Float.valueOf(2002.0f), this.float2020);
        Assert.assertEquals((double)2002.0, (double)preferences.getDouble(this.float2020.identifer(), (double)((Float)this.float2020.defaultValue()).floatValue()), (double)0.0);
    }

    @Test
    public void testSaveInt() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)2002, this.int2020);
        Assert.assertEquals((long)2002L, (long)preferences.getInt(this.int2020.identifer(), ((Integer)this.int2020.defaultValue()).intValue()));
    }

    @Test
    public void testSaveLong() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save((Object)2002L, this.long2020);
        Assert.assertEquals((long)2002L, (long)preferences.getLong(this.long2020.identifer(), ((Long)this.long2020.defaultValue()).longValue()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSaveUnknown() {
        IEclipsePreferences preferences = this.anyPreferences();
        OsgiPreferenceMetadataStore storage = new OsgiPreferenceMetadataStore(preferences);
        storage.save(new Object(), this.unknown);
    }

    private IEclipsePreferences anyPreferences() {
        return new EclipsePreferences();
    }
}

