/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.preferences.tests;

import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.junit.Assert;
import org.junit.Test;

public class PreferenceMetadataTest {
    @Test
    public void testPreferenceMetadata() {
        PreferenceMetadata option = new PreferenceMetadata(String.class, "identifier", (Object)"default", "name", "description");
        Assert.assertEquals((Object)"identifier", (Object)option.identifer());
        Assert.assertEquals((Object)"default", (Object)option.defaultValue());
        Assert.assertEquals((Object)"name", (Object)option.name());
        Assert.assertEquals((Object)"description", (Object)option.description());
        Assert.assertEquals(String.class, (Object)option.valueClass());
    }

    @Test(expected=NullPointerException.class)
    public void testPreferenceMetadataNullValueType() {
        new PreferenceMetadata(null, "identifier", (Object)"default", "name", "description");
    }

    @Test(expected=NullPointerException.class)
    public void testPreferenceMetadataNullIdentifier() {
        new PreferenceMetadata(Object.class, null, (Object)"default", "name", "description");
    }

    @Test(expected=NullPointerException.class)
    public void testPreferenceMetadataNullDefaultValue() {
        new PreferenceMetadata(Object.class, "identifier", null, "name", "description");
    }

    @Test(expected=NullPointerException.class)
    public void testPreferenceMetadataNullName() {
        new PreferenceMetadata(Object.class, "identifier", (Object)"default", null, "description");
    }

    @Test(expected=NullPointerException.class)
    public void testPreferenceMetadataNullDescription() {
        new PreferenceMetadata(Object.class, "identifier", (Object)"default", "name", null);
    }
}

