/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.preferences.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.UserScope;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class ScopeStorageLocationTest {
    @Test
    public void testInstanceScope_writeLocation() throws Exception {
        Path instanceLocation = ScopeStorageLocationTest.getInstancePreferenceLocation();
        ScopeStorageLocationTest.assertWriteLocation(InstanceScope.INSTANCE, instanceLocation);
    }

    @Test
    public void testInstanceScope_readLocation() throws Exception {
        Path instanceLocation = ScopeStorageLocationTest.getInstancePreferenceLocation();
        ScopeStorageLocationTest.assertReadLocation(InstanceScope.INSTANCE, instanceLocation);
    }

    private static Path getInstancePreferenceLocation() throws URISyntaxException {
        return Path.of(Platform.getInstanceLocation().getURL().toURI()).resolve(".metadata/.plugins/org.eclipse.core.runtime/");
    }

    @Test
    public void testConfigurationScope_writeLocation() throws Exception {
        Path configurationLocation = ScopeStorageLocationTest.getConfigurationPreferenceLocation();
        ScopeStorageLocationTest.assertWriteLocation(ConfigurationScope.INSTANCE, configurationLocation);
    }

    @Test
    public void testConfigurationScope_readLocation() throws Exception {
        Path configurationLocation = ScopeStorageLocationTest.getConfigurationPreferenceLocation();
        ScopeStorageLocationTest.assertReadLocation(ConfigurationScope.INSTANCE, configurationLocation);
    }

    private static Path getConfigurationPreferenceLocation() throws URISyntaxException {
        return Path.of(Platform.getConfigurationLocation().getURL().toURI());
    }

    @Test
    public void testUserScope_writeLocation() throws Exception {
        Path configurationLocation = ScopeStorageLocationTest.getUserPreferenenceLocation();
        ScopeStorageLocationTest.assertWriteLocation(UserScope.INSTANCE, configurationLocation);
    }

    @Test
    public void testUserScope_readLocation() throws Exception {
        Path configurationLocation = ScopeStorageLocationTest.getUserPreferenenceLocation();
        ScopeStorageLocationTest.assertReadLocation(UserScope.INSTANCE, configurationLocation);
    }

    private static Path getUserPreferenenceLocation() {
        return Path.of(System.getProperty("user.home") + "/.eclipse", new String[0]);
    }

    private static void assertWriteLocation(IScopeContext scope, Path expectedPreferenceLocation) throws BackingStoreException, IOException {
        Path expectedFileLocation = expectedPreferenceLocation.resolve(".settings/foo.bar.prefs");
        Assert.assertFalse((boolean)Files.exists(expectedFileLocation, new LinkOption[0]));
        try {
            IEclipsePreferences node = scope.getNode("foo.bar");
            node.putInt("someCount", 5);
            node.flush();
            String preferenceFileContent = Files.readString(expectedFileLocation);
            Assert.assertEquals((Object)"eclipse.preferences.version=1\nsomeCount=5\n".replace("\n", System.lineSeparator()), (Object)preferenceFileContent);
        }
        finally {
            Files.deleteIfExists(expectedFileLocation);
        }
    }

    private static void assertReadLocation(IScopeContext scope, Path expectedPreferenceLocation) throws BackingStoreException, IOException {
        Path expectedFileLocation = expectedPreferenceLocation.resolve(".settings/foo.bar.buzz.prefs");
        Assert.assertFalse((boolean)Files.exists(expectedFileLocation, new LinkOption[0]));
        try {
            Files.createDirectories(expectedFileLocation.getParent(), new FileAttribute[0]);
            Files.writeString(expectedFileLocation, (CharSequence)"eclipse.preferences.version=1\naSetting=HelloWorld\n", new OpenOption[0]);
            Assert.assertEquals((Object)"HelloWorld", (Object)scope.getNode("foo.bar.buzz").get("aSetting", null));
        }
        finally {
            Files.deleteIfExists(expectedFileLocation);
        }
    }
}

