/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.tests.views.properties.tabbed.decorations.TabbedPropertySheetPageWithDecorations;
import org.eclipse.ui.tests.views.properties.tabbed.decorations.views.DecorationTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedPropertySheetPageDecorationsTest {
    private DecorationTestsView decorationTestsView;
    private TreeNode[] treeNodes;

    @Before
    public void setUp() throws WorkbenchException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Assert.assertNotNull((Object)workbenchPage);
        this.closeIntroView(workbenchPage);
        this.processUiEvents();
        workbenchPage.closeAllPerspectives(false, false);
        this.processUiEvents();
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        this.processUiEvents();
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.decorations.views.DecorationTestsView");
        this.processUiEvents();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)(view instanceof DecorationTestsView));
        Assert.assertTrue((boolean)workbenchPage.isPartVisible((IWorkbenchPart)view));
        this.decorationTestsView = (DecorationTestsView)view;
        IContentProvider contentProvider = this.decorationTestsView.getViewer().getContentProvider();
        Assert.assertTrue((boolean)(contentProvider instanceof TestsViewContentProvider));
        TestsViewContentProvider viewContentProvider = (TestsViewContentProvider)contentProvider;
        this.treeNodes = viewContentProvider.getInvisibleRoot().getChildren();
        Assert.assertEquals((long)8L, (long)this.treeNodes.length);
    }

    private void closeIntroView(IWorkbenchPage workbenchPage) {
        IViewPart intro = workbenchPage.findView("org.eclipse.ui.internal.introview");
        if (intro != null) {
            workbenchPage.hideView(intro);
        }
    }

    @After
    public void tearDown() {
        this.processUiEvents();
        this.setSelection(new TreeNode[0]);
    }

    private void processUiEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    private void setSelection(TreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.decorationTestsView.getViewer().setSelection((ISelection)selection, true);
    }

    @Test
    public void test_widestLabelIndex1_WithoutDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(false);
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
        Assert.assertEquals((long)1L, (long)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_widestLabelIndex1_WithDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(true);
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
        Assert.assertEquals((long)0L, (long)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_widestLabelIndex2_WithoutDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(false);
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
        Assert.assertEquals((long)0L, (long)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_widestLabelIndex2_WithDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(true);
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
        Assert.assertEquals((long)1L, (long)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }
}

