/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsColor;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsElement;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsShape;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsTreeNode;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedPropertySheetPageDynamicTest {
    private DynamicTestsView dynamicTestsView;
    private DynamicTestsTreeNode[] treeNodes;

    @Before
    public void setUp() throws WorkbenchException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Assert.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView");
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)(view instanceof DynamicTestsView));
        this.dynamicTestsView = (DynamicTestsView)view;
        IContentProvider contentProvider = this.dynamicTestsView.getViewer().getContentProvider();
        Assert.assertTrue((boolean)(contentProvider instanceof DynamicTestsViewContentProvider));
        DynamicTestsViewContentProvider viewContentProvider = (DynamicTestsViewContentProvider)contentProvider;
        this.treeNodes = (DynamicTestsTreeNode[])viewContentProvider.getInvisibleRoot().getChildren();
        Assert.assertEquals((long)11L, (long)this.treeNodes.length);
    }

    @After
    public void tearDown() {
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.setSelection(new DynamicTestsTreeNode[0]);
    }

    private void setSelection(DynamicTestsTreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.dynamicTestsView.getViewer().setSelection((ISelection)selection, true);
    }

    @Test
    public void test_BlueStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_all_blue();
    }

    @Test
    public void test_BlueDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_all_blue();
    }

    @Test
    public void test_BlueDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_all_blue();
    }

    public void select_all_blue() {
        ArrayList<DynamicTestsTreeNode> blueList = new ArrayList<DynamicTestsTreeNode>();
        DynamicTestsTreeNode[] dynamicTestsTreeNodeArray = this.treeNodes;
        int n = this.treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicTestsTreeNode treeNode = dynamicTestsTreeNodeArray[n2];
            if (DynamicTestsColor.BLUE.equals(treeNode.getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_COLOR))) {
                blueList.add(treeNode);
            }
            ++n2;
        }
        DynamicTestsTreeNode[] selectNodes = blueList.toArray(new DynamicTestsTreeNode[blueList.size()]);
        Assert.assertEquals((long)3L, (long)blueList.size());
        this.setSelection(selectNodes);
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Element", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Color", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
    }

    @Test
    public void test_TriangleStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_all_triangle();
    }

    @Test
    public void test_TriangleDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_all_triangle();
    }

    @Test
    public void test_TriangleDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_all_triangle();
    }

    public void select_all_triangle() {
        ArrayList<DynamicTestsTreeNode> triangleList = new ArrayList<DynamicTestsTreeNode>();
        DynamicTestsTreeNode[] dynamicTestsTreeNodeArray = this.treeNodes;
        int n = this.treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicTestsTreeNode treeNode = dynamicTestsTreeNodeArray[n2];
            if (DynamicTestsShape.TRIANGLE.equals(treeNode.getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_SHAPE))) {
                triangleList.add(treeNode);
            }
            ++n2;
        }
        DynamicTestsTreeNode[] selectNodes = triangleList.toArray(new DynamicTestsTreeNode[triangleList.size()]);
        Assert.assertEquals((long)4L, (long)triangleList.size());
        this.setSelection(selectNodes);
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Element", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Shape", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
    }

    @Test
    public void test_BlackTriangleStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_BlackTriangleDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Black", (Object)tabDescriptors[3].getLabel());
        Assert.assertEquals((long)4L, (long)tabDescriptors.length);
    }

    @Test
    public void test_BlackTriangleDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    public void select_blackTriangle() {
        DynamicTestsTreeNode blackTriangleNode = null;
        DynamicTestsTreeNode[] dynamicTestsTreeNodeArray = this.treeNodes;
        int n = this.treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicTestsTreeNode treeNode = dynamicTestsTreeNodeArray[n2];
            if (DynamicTestsColor.BLACK.equals(treeNode.getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_COLOR))) {
                blackTriangleNode = treeNode;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(blackTriangleNode);
        this.setSelection(new DynamicTestsTreeNode[]{blackTriangleNode});
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Element", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Shape", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Advanced", (Object)tabDescriptors[2].getLabel());
    }

    @Test
    public void test_RedStarStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Advanced", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_RedStarDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Advanced", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_RedStarDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Star", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((Object)"Advanced", (Object)tabDescriptors[3].getLabel());
        Assert.assertEquals((long)4L, (long)tabDescriptors.length);
    }

    public void select_RedStar() {
        DynamicTestsTreeNode redStarNode = null;
        DynamicTestsTreeNode[] dynamicTestsTreeNodeArray = this.treeNodes;
        int n = this.treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicTestsTreeNode treeNode = dynamicTestsTreeNodeArray[n2];
            if (DynamicTestsShape.STAR.equals(treeNode.getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_SHAPE))) {
                redStarNode = treeNode;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(redStarNode);
        this.setSelection(new DynamicTestsTreeNode[]{redStarNode});
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Element", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Color", (Object)tabDescriptors[1].getLabel());
    }
}

