/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.views.properties.tabbed.model.Error;
import org.eclipse.ui.tests.views.properties.tabbed.model.File;
import org.eclipse.ui.tests.views.properties.tabbed.model.Folder;
import org.eclipse.ui.tests.views.properties.tabbed.model.Information;
import org.eclipse.ui.tests.views.properties.tabbed.model.Warning;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedPropertySheetPageOverrideTest {
    private OverrideTestsView overrideTestsView;

    @Before
    public void setUp() throws WorkbenchException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Assert.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView");
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)(view instanceof OverrideTestsView));
        this.overrideTestsView = (OverrideTestsView)view;
    }

    @After
    public void tearDown() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    @Test
    public void test_tabForEmpty() {
        this.overrideTestsView.setSelection(null);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Empty Item", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((long)1L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabForError() {
        this.overrideTestsView.setSelection(Error.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Warning", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Error", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((Object)"Error", (Object)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabForFile() {
        this.overrideTestsView.setSelection(File.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"File", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"File", (Object)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((Object)"Folder", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabForFolder() {
        this.overrideTestsView.setSelection(Folder.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"File", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Folder", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Folder", (Object)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabForInformation() {
        this.overrideTestsView.setSelection(Information.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Information", (Object)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((Object)"Warning", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Error", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabForWarning() {
        this.overrideTestsView.setSelection(Warning.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Warning", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Warning", (Object)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((Object)"Error", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }
}

