/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.tests.views.properties.tabbed.sections.InformationTwoSection;
import org.eclipse.ui.tests.views.properties.tabbed.sections.NameSection;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsView;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedPropertySheetPageTest {
    private TestsView testsView;
    private TreeNode[] treeNodes;

    @Before
    public void setUp() throws Exception {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Assert.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.views.TestsView");
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)(view instanceof TestsView));
        this.testsView = (TestsView)view;
        IContentProvider contentProvider = this.testsView.getViewer().getContentProvider();
        Assert.assertTrue((boolean)(contentProvider instanceof TestsViewContentProvider));
        TestsViewContentProvider viewContentProvider = (TestsViewContentProvider)contentProvider;
        this.treeNodes = viewContentProvider.getInvisibleRoot().getChildren();
        Assert.assertEquals((long)this.treeNodes.length, (long)8L);
    }

    @After
    public void tearDown() {
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.setSelection(new TreeNode[0]);
    }

    private void setSelection(TreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.testsView.getViewer().setSelection((ISelection)selection, true);
    }

    @Test
    public void test_tabDisplay() {
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
    }

    @Test
    public void test_enablesForFilter() {
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((long)2L, (long)tabDescriptors.length);
    }

    @Test
    public void test_sectionInformationTwoFilter() {
        this.setSelection(new TreeNode[]{this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        TabContents tabContents = this.testsView.getTabbedPropertySheetPage().getCurrentTab();
        ISection[] sections = tabContents.getSections();
        Assert.assertEquals((long)2L, (long)sections.length);
        Assert.assertEquals(NameSection.class, sections[0].getClass());
        Assert.assertEquals(InformationTwoSection.class, sections[1].getClass());
    }

    @Test
    public void test_selectThreeMessageNodes() {
        this.setSelection(new TreeNode[]{this.treeNodes[1], this.treeNodes[2], this.treeNodes[3]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((long)1L, (long)tabDescriptors.length);
    }

    @Test
    public void test_widestLabelIndex1() {
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Information", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
        Assert.assertEquals((long)1L, (long)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_widestLabelIndex2() {
        this.setSelection(new TreeNode[]{this.treeNodes[2]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Error", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
        Assert.assertEquals((long)2L, (long)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_widestLabelIndex3() {
        this.setSelection(new TreeNode[]{this.treeNodes[3]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Name", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"Warning", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"Message", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((long)3L, (long)tabDescriptors.length);
        Assert.assertEquals((long)1L, (long)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    @Test
    public void test_selectThreeResourceNodes() {
        this.setSelection(new TreeNode[]{this.treeNodes[5], this.treeNodes[6], this.treeNodes[7]});
        ITabDescriptor[] TabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"Resource", (Object)TabDescriptors[0].getLabel());
        Assert.assertEquals((long)1L, (long)TabDescriptors.length);
    }

    @Test
    public void test_noPropertiesAvailable() {
        TabContents tabContents = this.testsView.getTabbedPropertySheetPage().getCurrentTab();
        Assert.assertNull((Object)tabContents);
        ITabDescriptor[] TabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((long)0L, (long)TabDescriptors.length);
        Assert.assertEquals((long)-1L, (long)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }
}

