/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsLabelSection;
import org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsView;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedPropertySheetPageTextTest {
    private static final long TIME_OUT_TO_GET_ACTIVE_TABS = 30000L;
    private TextTestsView textTestsView;

    @Before
    public void setUp() throws WorkbenchException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        Assert.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsView");
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((boolean)(view instanceof TextTestsView));
        this.textTestsView = (TextTestsView)view;
    }

    @After
    public void tearDown() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    @Test
    public void test_tabForSelectedTextDisplay() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("This is a test");
        this.textTestsView.getViewer().setSelectedRange(0, 14);
        ITabDescriptor[] tabDescriptors = this.waitForActiveTabs();
        Assert.assertEquals((Object)"This", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"is", (Object)tabDescriptors[1].getLabel());
        Assert.assertEquals((Object)"a", (Object)tabDescriptors[2].getLabel());
        Assert.assertEquals((Object)"test", (Object)tabDescriptors[3].getLabel());
        Assert.assertEquals((long)4L, (long)tabDescriptors.length);
    }

    @Test
    public void test_tabSelectedTab() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("The fifth tab is selected");
        this.textTestsView.getViewer().setSelectedRange(0, 26);
        ITabDescriptor[] tabDescriptors = this.waitForActiveTabs();
        Assert.assertEquals((Object)"The", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"The", (Object)this.textTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        Assert.assertEquals((Object)"selected", (Object)tabDescriptors[4].getLabel());
        this.textTestsView.getTabbedPropertySheetPage().setSelectedTab(tabDescriptors[4].getId());
        tabDescriptors = this.textTestsView.getTabbedPropertySheetPage().getActiveTabs();
        Assert.assertEquals((Object)"The", (Object)tabDescriptors[0].getLabel());
        Assert.assertEquals((Object)"selected", (Object)tabDescriptors[4].getLabel());
        Assert.assertEquals((Object)"selected", (Object)this.textTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
    }

    private ITabDescriptor[] waitForActiveTabs() {
        ITabDescriptor[] tabDescriptors;
        long threshold = System.currentTimeMillis() + 30000L;
        do {
            this.textTestsView.getSite().getShell().getDisplay().readAndDispatch();
        } while ((tabDescriptors = this.textTestsView.getTabbedPropertySheetPage().getActiveTabs()).length == 0 && System.currentTimeMillis() < threshold);
        Assert.assertTrue((String)"No tab got activated", (tabDescriptors.length > 0 ? 1 : 0) != 0);
        return tabDescriptors;
    }

    @Test
    public void test_listOfSections() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("This is a test");
        this.textTestsView.getViewer().setSelectedRange(0, 14);
        this.waitForActiveTabs();
        TabContents tabContents = this.textTestsView.getTabbedPropertySheetPage().getCurrentTab();
        ISection[] sections = tabContents.getSections();
        Assert.assertEquals((long)1L, (long)sections.length);
        Assert.assertEquals(TextTestsLabelSection.class, sections[0].getClass());
    }
}

