/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.override;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.tests.views.properties.tabbed.model.Element;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsSelection;

public class OverrideTestsSelectionProvider
implements ISelectionProvider {
    private final ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private final TableViewer viewer;

    OverrideTestsSelectionProvider(TableViewer aViewer) {
        this.viewer = aViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        IStructuredSelection structuredSelection = this.viewer.getStructuredSelection();
        if (structuredSelection.isEmpty()) {
            return new OverrideTestsSelection(null);
        }
        Element element = (Element)structuredSelection.getFirstElement();
        return new OverrideTestsSelection(element);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ISelectionChangedListener l = (ISelectionChangedListener)listener;
            l.selectionChanged(event);
            ++n2;
        }
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }
}

