/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.examples.controls;


import org.eclipse.swt.examples.controlexample.CustomControlExample;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

/**
 * <code>CustomControls</code> is a simple demonstration
 * of the custom controls defined by SWT.  It consists of a workbench
 * view and tab folder where each tab in the folder allows the
 * user to interact with a control.
 * 
 * @see ViewPart
 */
public class CustomControlView extends ControlView {

	/**
	 * Create the example
	 * 
	 * @see ViewPart#createPartControl(Composite)
	 */
	@Override
	public void createPartControl(Composite frame) {
		instance = new CustomControlExample(frame);
	}
}
