/*******************************************************************************
 * Copyright (c) 2009, 2015 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ua.tests.help.performance;

import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.eclipse.ua.tests.help.util.LoadServletUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

/**
 * A version of the servlet read test with a low iteration count
 */

public class LowIterationHelpServerTest extends PerformanceTestCaseJunit5 {

	@AfterEach
	@Override
	public void tearDown() throws Exception {
		LoadServletUtil.stopServer();
		super.tearDown();
	}

	@Test
	public void testServletRead20x() throws Exception {
		tagAsSummary("Servlet Read", Dimension.ELAPSED_PROCESS);
		LoadServletUtil.startServer();
		// run the tests
		for (int i=0; i < 15; ++i) {
			boolean warmup = i < 2;
			if (!warmup) {
				startMeasuring();
			}

			for (int j = 0; j <= 20; j++) {
				LoadServletUtil.readLoadServlet(200);
			}

			if (!warmup) {
				stopMeasuring();
			}
		}

		commitMeasurements();
		assertPerformance();
	}

	@Test
	public void testStartServer() throws Exception {
		tagAsSummary("Start Server", Dimension.ELAPSED_PROCESS);

		// run the tests
		for (int i=0; i < 25; ++i) {
			boolean warmup = i < 2;
			LoadServletUtil.stopServer();
			if (!warmup) {
				startMeasuring();
			}

			LoadServletUtil.startServer();

			if (!warmup) {
				stopMeasuring();
			}
		}

		commitMeasurements();
		assertPerformance();
	}

}
