/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.dnd;

import aQute.bnd.maven.MavenCapability;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.pde.bnd.ui.dnd.GAVDropTargetListener;
import org.eclipse.swt.custom.StyledText;
import org.osgi.resource.Resource;

public class GradleDropTargetListener
extends GAVDropTargetListener {
    private static final IPreferencesService prefsService = Platform.getPreferencesService();

    public GradleDropTargetListener(StyledText styledText) {
        super(styledText);
    }

    @Override
    void format(GAVDropTargetListener.FormatEvent formatEvent) {
        if (formatEvent.isNoVersion()) {
            this.format(formatEvent.getResource(), formatEvent.useAlternateSyntax() ? Syntax.GRADLE_MAP_NO_VERSION : Syntax.GRADLE_STRING_NO_VERSION, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), GradleDropTargetListener.indent(this.isTabs(), this.getSize()));
        } else {
            this.format(formatEvent.getResource(), formatEvent.useAlternateSyntax() ? Syntax.GRADLE_MAP : Syntax.GRADLE_STRING, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), GradleDropTargetListener.indent(this.isTabs(), this.getSize()));
        }
    }

    @Override
    boolean hasAlternateSyntax() {
        return true;
    }

    int getSize() {
        if (this.isTabs()) {
            return 1;
        }
        return prefsService.getInt("org.eclipse.ui.editors.prefs", "tabWidth", 4, null);
    }

    boolean isTabs() {
        return !prefsService.getBoolean("org.eclipse.ui.editors.prefs", "spacesForTabs", false, null);
    }

    private void format(Resource resource, Syntax syntax, String lineAtInsertionPoint, String indentPrefix, String indent) {
        MavenCapability mc = MavenCapability.getMavenCapability((Resource)resource);
        if (mc == null) {
            return;
        }
        if (lineAtInsertionPoint.trim().startsWith("dependencies")) {
            indentPrefix = (String)indentPrefix + indent;
        }
        String group = mc.maven_groupId();
        String identity = mc.maven_artifactId();
        String version = mc.maven_version().toString();
        String classifier = mc.maven_classifier();
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append((String)indentPrefix).append("implementation ");
        switch (syntax) {
            case GRADLE_MAP: {
                sb.append("group: \"").append(group).append("\", name: \"").append(identity).append("\", version: \"").append(version).append("\"");
                if (classifier.isEmpty()) break;
                sb.append(", classifier: \"").append(classifier).append("\"");
                break;
            }
            case GRADLE_MAP_NO_VERSION: {
                sb.append("group: \"").append(group).append("\", name: \"").append(identity).append("\"");
                if (classifier.isEmpty()) break;
                sb.append(", classifier: \"").append(classifier).append("\"");
                break;
            }
            case GRADLE_STRING: {
                sb.append("'").append(group).append(":").append(identity).append(":").append(version);
                if (!classifier.isEmpty()) {
                    sb.append(":").append(classifier);
                }
                sb.append("'");
                break;
            }
            case GRADLE_STRING_NO_VERSION: {
                sb.append("'").append(group).append(":").append(identity).append("'");
            }
        }
        this.getStyledText().insert(sb.toString());
    }

    static enum Syntax {
        GRADLE_MAP,
        GRADLE_MAP_NO_VERSION,
        GRADLE_STRING,
        GRADLE_STRING_NO_VERSION;

    }
}

