/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryStandin;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryContentProvider
implements ITreeContentProvider {
    private Viewer fViewer;
    private HashMap<LibraryStandin, Object[]> fChildren = new HashMap();
    private LibraryStandin[] fLibraries = new LibraryStandin[0];

    public void dispose() {
        this.fChildren.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fLibraries;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LibraryStandin) {
            LibraryStandin standin = (LibraryStandin)parentElement;
            Object[] children = this.fChildren.get(standin);
            if (children == null) {
                children = new Object[]{new SubElement(standin, 2), new SubElement(standin, 1)};
                this.fChildren.put(standin, children);
            }
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof SubElement) {
            return ((SubElement)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof LibraryStandin;
    }

    public void setLibraries(LibraryLocation[] libs) {
        this.fLibraries = new LibraryStandin[libs.length];
        int i = 0;
        while (i < libs.length) {
            this.fLibraries[i] = new LibraryStandin(libs[i]);
            ++i;
        }
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    public LibraryLocation[] getLibraries() {
        LibraryLocation[] locations = new LibraryLocation[this.fLibraries.length];
        int i = 0;
        while (i < locations.length) {
            locations[i] = this.fLibraries[i].toLibraryLocation();
            ++i;
        }
        return locations;
    }

    private Set<Object> getSelectedLibraries(IStructuredSelection selection) {
        HashSet<Object> libraries = new HashSet<Object>();
        for (Object element : selection) {
            if (element instanceof LibraryStandin) {
                libraries.add(element);
                continue;
            }
            if (!(element instanceof SubElement)) continue;
            libraries.add(((SubElement)element).getParent());
        }
        return libraries;
    }

    public void up(IStructuredSelection selection) {
        Set<Object> libraries = this.getSelectedLibraries(selection);
        int i = 0;
        while (i < this.fLibraries.length - 1) {
            if (libraries.contains(this.fLibraries[i + 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i + 1];
                this.fLibraries[i + 1] = temp;
            }
            ++i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void down(IStructuredSelection selection) {
        Set<Object> libraries = this.getSelectedLibraries(selection);
        int i = this.fLibraries.length - 1;
        while (i > 0) {
            if (libraries.contains(this.fLibraries[i - 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i - 1];
                this.fLibraries[i - 1] = temp;
            }
            --i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void remove(IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>();
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        for (Object element : selection) {
            if (element instanceof LibraryStandin) {
                newLibraries.remove(element);
                continue;
            }
            SubElement subElement = (SubElement)element;
            subElement.remove();
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
    }

    public void add(LibraryLocation[] libs, IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>(this.fLibraries.length + libs.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        ArrayList<LibraryStandin> toAdd = new ArrayList<LibraryStandin>(libs.length);
        int i2 = 0;
        while (i2 < libs.length) {
            toAdd.add(new LibraryStandin(libs[i2]));
            ++i2;
        }
        if (selection.isEmpty()) {
            newLibraries.addAll(toAdd);
        } else {
            Object element = selection.getFirstElement();
            LibraryStandin firstLib = element instanceof LibraryStandin ? (LibraryStandin)element : ((SubElement)element).getParent();
            int index = newLibraries.indexOf(firstLib);
            newLibraries.addAll(index, toAdd);
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
    }

    public void setJavadoc(URL javadocLocation, IStructuredSelection selection) {
        Set<Object> libraries = this.getSelectedLibraries(selection);
        for (LibraryStandin libraryStandin : libraries) {
            libraryStandin.setJavadocLocation(javadocLocation);
        }
        this.fViewer.refresh();
    }

    public void setSourcePath(IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IStructuredSelection selection) {
        Set<Object> libraries = this.getSelectedLibraries(selection);
        if (sourceAttachmentPath == null) {
            sourceAttachmentPath = Path.EMPTY;
        }
        if (sourceAttachmentRootPath == null) {
            sourceAttachmentRootPath = Path.EMPTY;
        }
        for (LibraryStandin libraryStandin : libraries) {
            libraryStandin.setSystemLibrarySourcePath(sourceAttachmentPath);
            libraryStandin.setPackageRootPath(sourceAttachmentRootPath);
        }
        this.fViewer.refresh();
    }

    LibraryStandin[] getStandins() {
        return this.fLibraries;
    }

    public class SubElement {
        public static final int JAVADOC_URL = 1;
        public static final int SOURCE_PATH = 2;
        private LibraryStandin fParent;
        private int fType;

        public SubElement(LibraryStandin parent, int type) {
            this.fParent = parent;
            this.fType = type;
        }

        public LibraryStandin getParent() {
            return this.fParent;
        }

        public int getType() {
            return this.fType;
        }

        public void remove() {
            switch (this.fType) {
                case 1: {
                    this.fParent.setJavadocLocation(null);
                    break;
                }
                case 2: {
                    this.fParent.setSystemLibrarySourcePath((IPath)Path.EMPTY);
                }
            }
        }
    }
}

