/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitMigrationDelegate;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitLaunchShortcut
implements ILaunchShortcut2 {
    private static final String EMPTY_STRING = "";

    public void launch(IEditorPart editor, String mode) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            IMethod selectedMethod = this.resolveSelectedMethodName(editor, element);
            if (selectedMethod != null) {
                this.launch(new Object[]{selectedMethod}, mode);
            } else {
                this.launch(new Object[]{element}, mode);
            }
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private IMethod resolveSelectedMethodName(IEditorPart editor, ITypeRoot element) {
        IJavaElement elementAtOffset;
        ITextSelection textSelection;
        block8: {
            ISelection selection;
            block7: {
                ISelectionProvider selectionProvider;
                block6: {
                    try {
                        selectionProvider = editor.getSite().getSelectionProvider();
                        if (selectionProvider != null) break block6;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                selection = selectionProvider.getSelection();
                if (selection instanceof ITextSelection) break block7;
                return null;
            }
            textSelection = (ITextSelection)selection;
            elementAtOffset = SelectionConverter.getElementAtOffset((ITypeRoot)element, (ITextSelection)textSelection);
            if (elementAtOffset instanceof IMethod) break block8;
            return null;
        }
        IMethod method = (IMethod)elementAtOffset;
        ISourceRange nameRange = method.getNameRange();
        if (nameRange.getOffset() <= textSelection.getOffset() && textSelection.getOffset() + textSelection.getLength() <= nameRange.getOffset() + nameRange.getLength()) {
            return method;
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private void launch(Object[] elements, String mode) {
        try {
            IJavaElement elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                    selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
                }
                if (selected instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)selected;
                    switch (element.getElementType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: {
                            elementToLaunch = element;
                            break;
                        }
                        case 6: {
                            elementToLaunch = ((IClassFile)element).getType();
                            break;
                        }
                        case 5: {
                            elementToLaunch = this.findTypeToLaunch((ICompilationUnit)element, mode);
                        }
                    }
                }
            }
            if (elementToLaunch == null) {
                this.showNoTestsFoundDialog();
                return;
            }
            this.performLaunch(elementToLaunch, mode);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), JUnitMessages.JUnitLaunchShortcut_dialog_title, JUnitMessages.JUnitLaunchShortcut_message_launchfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), JUnitMessages.JUnitLaunchShortcut_dialog_title, JUnitMessages.JUnitLaunchShortcut_message_launchfailed);
        }
    }

    private void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)JUnitMessages.JUnitLaunchShortcut_dialog_title, (String)JUnitMessages.JUnitLaunchShortcut_message_notests);
    }

    private IType findTypeToLaunch(ICompilationUnit cu, String mode) throws InterruptedException, InvocationTargetException {
        IType[] types = this.findTypesToLaunch(cu);
        if (types.length == 0) {
            return null;
        }
        if (types.length > 1) {
            return this.chooseType(types, mode);
        }
        return types[0];
    }

    private IType[] findTypesToLaunch(ICompilationUnit cu) throws InterruptedException, InvocationTargetException {
        ITestKind testKind = TestKindRegistry.getContainerTestKind((IJavaElement)cu);
        return TestSearchEngine.findTests((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IJavaElement)cu, testKind);
    }

    private void performLaunch(IJavaElement element, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(element);
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temparary, mode);
        if (config == null) {
            config = temparary.doSave();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private IType chooseType(IType[] types, String mode) throws InterruptedException {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
        dialog.setElements((Object[])types);
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_dialog_title2);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToDebug);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToRun);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    private Shell getShell() {
        return JUnitPlugin.getActiveWorkbenchShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.jdt.junit.launchconfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException {
        String testName;
        String mainTypeQualifiedName;
        String containerHandleId;
        switch (element.getElementType()) {
            case 2: 
            case 3: 
            case 4: {
                String name = JavaElementLabels.getTextLabel((Object)element, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
                containerHandleId = element.getHandleIdentifier();
                mainTypeQualifiedName = EMPTY_STRING;
                testName = name.substring(name.lastIndexOf(47) + 1);
                break;
            }
            case 7: {
                containerHandleId = EMPTY_STRING;
                mainTypeQualifiedName = ((IType)element).getFullyQualifiedName('.');
                testName = element.getElementName();
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                containerHandleId = EMPTY_STRING;
                mainTypeQualifiedName = method.getDeclaringType().getFullyQualifiedName('.');
                testName = String.valueOf(method.getDeclaringType().getElementName()) + '.' + method.getElementName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid element type to create a launch configuration: " + element.getClass().getName());
            }
        }
        String testKindId = TestKindRegistry.getContainerTestKindId((IJavaElement)element);
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(testName));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainTypeQualifiedName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, element.getJavaProject().getElementName());
        wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", containerHandleId);
        wc.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
        JUnitMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)wc);
        AssertionVMArg.setArgDefault(wc);
        if (element instanceof IMethod) {
            wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", element.getElementName());
        }
        return wc;
    }

    protected String[] getAttributeNamesToCompare() {
        return new String[]{IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "org.eclipse.jdt.junit.CONTAINER", IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.jdt.junit.TESTNAME"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            String[] stringArray = attributeToCompare;
            int n = attributeToCompare.length;
            int n2 = 0;
            while (true) {
                String val2;
                if (n2 >= n) {
                    return true;
                }
                String element = stringArray[n2];
                String val1 = config1.getAttribute(element, EMPTY_STRING);
                if (!val1.equals(val2 = config2.getAttribute(element, EMPTY_STRING))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        List<ILaunchConfiguration> candidateConfigs = this.findExistingLaunchConfigurations(temporary);
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    private List<ILaunchConfiguration> findExistingLaunchConfigurations(ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (JUnitLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        return candidateConfigs;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return this.findExistingLaunchConfigurations(ss.getFirstElement());
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(final IEditorPart editor) {
        final ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            IMethod selectedMethod = null;
            if (Display.getCurrent() == null) {
                final IMethod[] temp = new IMethod[1];
                Runnable runnable = new Runnable(){

                    public void run() {
                        temp[0] = JUnitLaunchShortcut.this.resolveSelectedMethodName(editor, element);
                    }
                };
                Display.getDefault().syncExec(runnable);
                selectedMethod = temp[0];
            } else {
                selectedMethod = this.resolveSelectedMethodName(editor, element);
            }
            ITypeRoot candidate = element;
            if (selectedMethod != null) {
                candidate = selectedMethod;
            }
            return this.findExistingLaunchConfigurations(candidate);
        }
        return null;
    }

    private ILaunchConfiguration[] findExistingLaunchConfigurations(Object candidate) {
        if (!(candidate instanceof IJavaElement) && candidate instanceof IAdaptable) {
            candidate = ((IAdaptable)candidate).getAdapter(IJavaElement.class);
        }
        if (candidate instanceof IJavaElement) {
            IJavaElement elementToLaunch;
            block10: {
                IJavaElement element = (IJavaElement)candidate;
                elementToLaunch = null;
                try {
                    switch (element.getElementType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: {
                            elementToLaunch = element;
                            break;
                        }
                        case 6: {
                            elementToLaunch = ((IClassFile)element).getType();
                            break;
                        }
                        case 5: {
                            elementToLaunch = ((ICompilationUnit)element).findPrimaryType();
                        }
                    }
                    if (elementToLaunch != null) break block10;
                    return null;
                }
                catch (CoreException coreException) {}
            }
            ILaunchConfigurationWorkingCopy workingCopy = this.createLaunchConfiguration(elementToLaunch);
            List<ILaunchConfiguration> list = this.findExistingLaunchConfigurations(workingCopy);
            return list.toArray(new ILaunchConfiguration[list.size()]);
        }
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object selected = ss.getFirstElement();
            if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
            }
            if (selected instanceof IJavaElement) {
                return ((IJavaElement)selected).getResource();
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            try {
                return element.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }
}

