/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SplashLocationSection
extends PDESection {
    private FormEntry fPluginEntry;

    public SplashLocationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.SplashSection_title);
        section.setDescription(PDEUIMessages.SplashSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fPluginEntry = new FormEntry(client, toolkit, PDEUIMessages.SplashSection_plugin, PDEUIMessages.SplashSection_browse, false);
        this.fPluginEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                SplashLocationSection.this.getSplashInfo().setLocation(entry.getValue(), false);
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                SplashLocationSection.this.handleBrowse();
            }
        });
        this.fPluginEntry.setEditable(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void refresh() {
        ISplashInfo info = this.getSplashInfo();
        this.fPluginEntry.setValue(info.getLocation(), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fPluginEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fPluginEntry.cancelEdit();
        super.cancelEdit();
    }

    private ISplashInfo getSplashInfo() {
        ISplashInfo info = this.getProduct().getSplashInfo();
        if (info == null) {
            info = this.getModel().getFactory().createSplashInfo();
            this.getProduct().setSplashInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private void handleBrowse() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setElements((Object[])PluginRegistry.getActiveModels());
        dialog.setMultipleSelection(false);
        dialog.setTitle(PDEUIMessages.SplashSection_selection);
        dialog.setMessage(PDEUIMessages.SplashSection_message);
        if (dialog.open() == 0) {
            IPluginModelBase model = (IPluginModelBase)dialog.getFirstResult();
            this.fPluginEntry.setValue(model.getPluginBase().getId());
        }
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

