/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkCompletedHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) {
        final ExecutionEvent finalEvent = event;
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(MarkerMessages.markCompletedHandler_task, 100);
                    IMarker[] markers = MarkCompletedHandler.this.getSelectedMarkers(finalEvent);
                    if (markers.length == 0) {
                        return;
                    }
                    HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
                    attrs.put("done", Boolean.TRUE);
                    UpdateMarkersOperation op = new UpdateMarkersOperation(markers, attrs, MarkerMessages.markCompletedAction_title, true);
                    monitor.worked(20);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    MarkCompletedHandler.this.execute((IUndoableOperation)op, MarkerMessages.markCompletedAction_title, (IProgressMonitor)new SubProgressMonitor(monitor, 80), null);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e), 1);
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(2, e.getLocalizedMessage(), (Throwable)e), 1);
        }
        return this;
    }
}

