/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.ctxhelp.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ua.ui.editor.ctxhelp.CtxHelpTreeSection;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class CtxHelpAbstractDetails
extends PDEDetails {
    private static final int NUM_COLUMNS = 3;
    private CtxHelpTreeSection fMasterSection;
    private Section fMainSection;
    private String fContextID;

    public CtxHelpAbstractDetails(CtxHelpTreeSection masterSection, String contextID) {
        this.fMasterSection = masterSection;
        this.fContextID = contextID;
        this.fMainSection = null;
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout((boolean)false, (int)1));
        this.createDetails(parent);
        this.hookListeners();
    }

    public void createDetails(Composite parent) {
        int style = 256;
        if (this.getDetailsDescription() != null) {
            style |= 0x80;
        }
        this.fMainSection = this.getPage().createUISection(parent, this.getDetailsTitle(), this.getDetailsDescription(), style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fMainSection, 3);
        GridData data = new GridData(1808);
        this.fMainSection.setLayoutData((Object)data);
        this.createFields(sectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fMainSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fMainSection);
    }

    protected abstract void createFields(Composite var1);

    protected abstract String getDetailsTitle();

    protected abstract String getDetailsDescription();

    public abstract void hookListeners();

    public abstract void updateFields();

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return this.fContextID;
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)this.getManagedForm().getContainer();
    }

    public boolean isEditable() {
        return this.fMasterSection.isEditable();
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public boolean isEditableElement() {
        return this.fMasterSection.isEditable();
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public CtxHelpTreeSection getMasterSection() {
        return this.fMasterSection;
    }

    protected void createLabel(Composite parent, FormToolkit toolkit, String text) {
        Label label = toolkit.createLabel(parent, text, 64);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    protected void createSpace(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), "");
    }

    protected Object getFirstSelectedObject(ISelection selection) {
        IStructuredSelection structuredSel = (IStructuredSelection)selection;
        if (structuredSel == null) {
            return null;
        }
        return structuredSel.getFirstElement();
    }
}

