/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;

public abstract class TextSearchLabelProvider
extends LabelProvider {
    private AbstractTextSearchViewPage fPage;

    public TextSearchLabelProvider(AbstractTextSearchViewPage page) {
        this.fPage = page;
    }

    public AbstractTextSearchViewPage getPage() {
        return this.fPage;
    }

    protected final StyledString getColoredLabelWithCounts(Object element, StyledString coloredName) {
        String name = coloredName.getString();
        String decorated = this.getLabelWithCounts(element, name);
        if (decorated.length() > name.length()) {
            StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)coloredName);
        }
        return coloredName;
    }

    protected final String getLabelWithCounts(Object element, String elementName) {
        int matchCount = this.fPage.getInput().getMatchCount(element);
        if (matchCount < 2) {
            return elementName;
        }
        return Messages.format(SearchMessages.TextSearchLabelProvider_matchCountFormat, new String[]{elementName, String.valueOf(matchCount)});
    }
}

