/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

class RemoveResultAction
extends Action {
    private ISelectionProvider fSelectionProvider;

    public RemoveResultAction(ISelectionProvider provider, boolean stringsDependOnMatchCount) {
        this.fSelectionProvider = provider;
        if (!stringsDependOnMatchCount || this.usePluralLabel()) {
            this.setText(SearchMessages.SearchResultView_removeEntries_text);
            this.setToolTipText(SearchMessages.SearchResultView_removeEntries_tooltip);
        } else {
            this.setText(SearchMessages.SearchResultView_removeEntry_text);
            this.setToolTipText(SearchMessages.SearchResultView_removeEntry_tooltip);
        }
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_rem.gif");
    }

    public void run() {
        final IMarker[] markers = this.getMarkers(this.fSelectionProvider.getSelection());
        if (markers != null) {
            BusyIndicator.showWhile((Display)SearchPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SearchPlugin.getWorkspace().deleteMarkers(markers);
                    }
                    catch (CoreException ex) {
                        ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
                    }
                }
            });
        }
    }

    private IMarker[] getMarkers(ISelection s) {
        if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        int size = selection.size();
        if (size <= 0) {
            return null;
        }
        ArrayList markers = new ArrayList(size * 3);
        int markerCount = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)iter.next();
            markerCount += entry.getMatchCount();
            markers.addAll(entry.getMarkers());
        }
        return markers.toArray(new IMarker[markerCount]);
    }

    private boolean usePluralLabel() {
        ISelection s = this.fSelectionProvider.getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return true;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ISearchResultViewEntry) {
            return ((ISearchResultViewEntry)firstElement).getMatchCount() > 1;
        }
        return false;
    }
}

