/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaExceptionBreakpoint;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExceptionBreakpointEditor
extends StandardJavaBreakpointEditor {
    public static final int PROP_CAUGHT = 4128;
    public static final int PROP_UNCAUGHT = 4129;
    public static final int PROP_SUBCLASSES = 4130;
    private Button fCaught;
    private Button fUncaught;
    private Button fSubclasses;

    public Control createControl(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)0);
        super.createControl(container);
        Composite composite = SWTFactory.createComposite((Composite)container, (Font)parent.getFont(), (int)5, (int)1, (int)0, (int)0, (int)0);
        this.fCaught = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_1), 4128);
        this.fUncaught = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_2), 4129);
        this.fSubclasses = this.createSusupendPropertyEditor(composite, this.processMnemonics(PropertyPageMessages.ExceptionBreakpointEditor_3), 4130);
        return container;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) throws CoreException {
        super.setBreakpoint(breakpoint);
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            IJavaExceptionBreakpoint ex = (IJavaExceptionBreakpoint)breakpoint;
            this.fCaught.setEnabled(true);
            this.fUncaught.setEnabled(true);
            this.fSubclasses.setEnabled(true);
            this.fCaught.setSelection(ex.isCaught());
            this.fUncaught.setSelection(ex.isUncaught());
            this.fSubclasses.setSelection(((JavaExceptionBreakpoint)ex).isSuspendOnSubclasses());
        } else {
            this.fCaught.setEnabled(false);
            this.fUncaught.setEnabled(false);
            this.fSubclasses.setEnabled(false);
        }
    }

    public void doSave() throws CoreException {
        super.doSave();
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IJavaExceptionBreakpoint) {
            IJavaExceptionBreakpoint ex = (IJavaExceptionBreakpoint)breakpoint;
            ex.setCaught(this.fCaught.getSelection());
            ex.setUncaught(this.fUncaught.getSelection());
            ((JavaExceptionBreakpoint)ex).setSuspendOnSubclasses(this.fSubclasses.getSelection());
        }
    }
}

