/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.ui.IBundleContentWizard;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.ITemplateSection;

public abstract class AbstractNewPluginTemplateWizard
extends Wizard
implements IBundleContentWizard {
    private IFieldData data;

    public AbstractNewPluginTemplateWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEXPRJ_WIZ);
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void init(IFieldData data) {
        this.data = data;
        this.setWindowTitle(PDEUIMessages.PluginCodeGeneratorWizard_title);
    }

    public IFieldData getData() {
        return this.data;
    }

    protected abstract void addAdditionalPages();

    public final void addPages() {
        this.addAdditionalPages();
    }

    public boolean performFinish() {
        return true;
    }

    @Override
    public boolean performFinish(IProject project, IPluginModelBase model, IProgressMonitor monitor) {
        try {
            try {
                ITemplateSection[] sections = this.getTemplateSections();
                monitor.beginTask("", sections.length);
                int i = 0;
                while (i < sections.length) {
                    sections[i].execute(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++i;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                monitor.done();
                return false;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public abstract ITemplateSection[] getTemplateSections();

    @Override
    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        ITemplateSection[] sections = this.getTemplateSections();
        int i = 0;
        while (i < sections.length) {
            IPluginReference[] refs = sections[i].getDependencies(schemaVersion);
            int j = 0;
            while (j < refs.length) {
                if (!result.contains(refs[j])) {
                    result.add(refs[j]);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    @Override
    public String[] getNewFiles() {
        ArrayList<String> result = new ArrayList<String>();
        ITemplateSection[] sections = this.getTemplateSections();
        int i = 0;
        while (i < sections.length) {
            String[] newFiles = sections[i].getNewFiles();
            int j = 0;
            while (j < newFiles.length) {
                if (!result.contains(newFiles[j])) {
                    result.add(newFiles[j]);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean hasPages() {
        return this.getTemplateSections().length > 0;
    }

    @Override
    public String[] getImportPackages() {
        return new String[0];
    }
}

